/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.join;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.MappedExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetPrecondition;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.preprocessing.AbstractDataProcessing;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.Ontology;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import java.util.LinkedList;

public class ExampleSetMinus
extends AbstractDataProcessing {
    private InputPort subtrahendInput = (InputPort)this.getInputPorts().createPort("subtrahend");

    public ExampleSetMinus(OperatorDescription description) {
        super(description);
        this.subtrahendInput.addPrecondition(new ExampleSetPrecondition(this.subtrahendInput, 0, "id"));
    }

    @Override
    protected MetaData modifyMetaData(ExampleSetMetaData metaData) throws UndefinedParameterError {
        metaData.getNumberOfExamples().reduceByUnknownAmount();
        return metaData;
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        ExampleSet subtrahendSet = (ExampleSet)this.subtrahendInput.getData();
        ExampleSet minuendSet = exampleSet;
        subtrahendSet.remapIds();
        minuendSet.remapIds();
        Attribute minuendId = minuendSet.getAttributes().getId();
        Attribute subtrahendId = subtrahendSet.getAttributes().getId();
        if (minuendId == null || subtrahendId == null) {
            throw new UserError((Operator)this, 129);
        }
        if (minuendId.getValueType() != subtrahendId.getValueType()) {
            throw new UserError((Operator)this, 120, subtrahendId.getName(), Ontology.VALUE_TYPE_NAMES[subtrahendId.getValueType()], Ontology.VALUE_TYPE_NAMES[minuendId.getValueType()]);
        }
        LinkedList<Integer> indices = new LinkedList<Integer>();
        int i = 0;
        for (Example example : minuendSet) {
            double id = example.getValue(minuendId);
            Example subtrahendExample = null;
            subtrahendExample = minuendId.isNominal() ? subtrahendSet.getExampleFromId(subtrahendId.getMapping().getIndex(minuendId.getMapping().mapIndex((int)id))) : subtrahendSet.getExampleFromId(id);
            if (subtrahendExample == null) {
                indices.add(i);
            }
            ++i;
        }
        int[] indexArray = new int[indices.size()];
        for (int i2 = 0; i2 < indices.size(); ++i2) {
            indexArray[i2] = (Integer)indices.get(i2);
        }
        MappedExampleSet minusSet = new MappedExampleSet(minuendSet, indexArray);
        return minusSet;
    }

    @Override
    public boolean writesIntoExistingData() {
        return false;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), ExampleSetMinus.class, null);
    }
}

