/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.join;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.preprocessing.join.AbstractExampleSetJoin;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import java.util.HashSet;
import java.util.List;

public class ExampleSetJoin
extends AbstractExampleSetJoin {
    public static final String PARAMETER_JOIN_TYPE = "join_type";
    public static final String[] JOIN_TYPES = new String[]{"inner", "left", "right", "outer"};
    public static final int JOIN_TYPE_INNER = 0;
    public static final int JOIN_TYPE_LEFT = 1;
    public static final int JOIN_TYPE_RIGHT = 2;
    public static final int JOIN_TYPE_OUTER = 3;

    public ExampleSetJoin(OperatorDescription description) {
        super(description);
    }

    @Override
    protected MemoryExampleTable joinData(ExampleSet leftExampleSet, ExampleSet rightExampleSet, List<AbstractExampleSetJoin.AttributeSource> originalAttributeSources, List<Attribute> unionAttributeList) throws OperatorException {
        int joinType = this.getParameterAsInt(PARAMETER_JOIN_TYPE);
        leftExampleSet.remapIds();
        rightExampleSet.remapIds();
        Attribute leftIdAttribute = leftExampleSet.getAttributes().getId();
        Attribute rightIdAttribute = rightExampleSet.getAttributes().getId();
        MemoryExampleTable unionTable = new MemoryExampleTable(unionAttributeList);
        switch (joinType) {
            case 0: {
                for (Example leftExample : leftExampleSet) {
                    double leftIdValue = leftExample.getValue(leftIdAttribute);
                    int[] rightExampleIndices = null;
                    rightExampleIndices = leftIdAttribute.isNominal() ? rightExampleSet.getExampleIndicesFromId(rightIdAttribute.getMapping().getIndex(leftIdAttribute.getMapping().mapIndex((int)leftIdValue))) : rightExampleSet.getExampleIndicesFromId(leftIdValue);
                    if (rightExampleIndices != null) {
                        for (int rightExampleIndex : rightExampleIndices) {
                            Example rightExample = rightExampleSet.getExample(rightExampleIndex);
                            double[] unionDataRow = new double[unionAttributeList.size()];
                            int attributeIndex = 0;
                            for (AbstractExampleSetJoin.AttributeSource attributeSource : originalAttributeSources) {
                                if (attributeSource.getSource() == 1) {
                                    unionDataRow[attributeIndex] = leftExample.getValue(attributeSource.getAttribute());
                                } else if (attributeSource.getSource() == 2) {
                                    unionDataRow[attributeIndex] = rightExample.getValue(attributeSource.getAttribute());
                                }
                                ++attributeIndex;
                            }
                            unionTable.addDataRow(new DoubleArrayDataRow(unionDataRow));
                        }
                    }
                    this.checkForStop();
                }
                break;
            }
            case 1: {
                for (Example leftExample : leftExampleSet) {
                    double leftIdValue = leftExample.getValue(leftIdAttribute);
                    int[] rightExampleIndices = null;
                    rightExampleIndices = leftIdAttribute.isNominal() ? rightExampleSet.getExampleIndicesFromId(rightIdAttribute.getMapping().getIndex(leftIdAttribute.getMapping().mapIndex((int)leftIdValue))) : rightExampleSet.getExampleIndicesFromId(leftIdValue);
                    if (rightExampleIndices != null) {
                        for (int rightExampleIndex : rightExampleIndices) {
                            Example rightExample = rightExampleSet.getExample(rightExampleIndex);
                            double[] unionDataRow = new double[unionAttributeList.size()];
                            int attributeIndex = 0;
                            for (AbstractExampleSetJoin.AttributeSource attributeSource : originalAttributeSources) {
                                if (attributeSource.getSource() == 1) {
                                    unionDataRow[attributeIndex] = leftExample.getValue(attributeSource.getAttribute());
                                } else if (attributeSource.getSource() == 2) {
                                    unionDataRow[attributeIndex] = rightExample.getValue(attributeSource.getAttribute());
                                }
                                ++attributeIndex;
                            }
                            unionTable.addDataRow(new DoubleArrayDataRow(unionDataRow));
                        }
                    } else {
                        double[] unionDataRow = new double[unionAttributeList.size()];
                        int attributeIndex = 0;
                        for (AbstractExampleSetJoin.AttributeSource attributeSource : originalAttributeSources) {
                            if (attributeSource.getSource() == 1) {
                                unionDataRow[attributeIndex] = leftExample.getValue(attributeSource.getAttribute());
                            } else if (attributeSource.getSource() == 2) {
                                unionDataRow[attributeIndex] = Double.NaN;
                            }
                            ++attributeIndex;
                        }
                        unionTable.addDataRow(new DoubleArrayDataRow(unionDataRow));
                    }
                    this.checkForStop();
                }
                break;
            }
            case 2: {
                for (Example rightExample : rightExampleSet) {
                    double rightIdValue = rightExample.getValue(rightIdAttribute);
                    int[] leftExampleIndices = null;
                    leftExampleIndices = rightIdAttribute.isNominal() ? leftExampleSet.getExampleIndicesFromId(leftIdAttribute.getMapping().getIndex(rightIdAttribute.getMapping().mapIndex((int)rightIdValue))) : leftExampleSet.getExampleIndicesFromId(rightIdValue);
                    if (leftExampleIndices != null) {
                        for (int leftExampleIndex : leftExampleIndices) {
                            Example leftExample = leftExampleSet.getExample(leftExampleIndex);
                            double[] unionDataRow = new double[unionAttributeList.size()];
                            int attributeIndex = 0;
                            for (AbstractExampleSetJoin.AttributeSource attributeSource : originalAttributeSources) {
                                if (attributeSource.getSource() == 1) {
                                    unionDataRow[attributeIndex] = leftExample.getValue(attributeSource.getAttribute());
                                } else if (attributeSource.getSource() == 2) {
                                    unionDataRow[attributeIndex] = rightExample.getValue(attributeSource.getAttribute());
                                }
                                ++attributeIndex;
                            }
                            unionTable.addDataRow(new DoubleArrayDataRow(unionDataRow));
                        }
                    } else {
                        double[] unionDataRow = new double[unionAttributeList.size()];
                        int attributeIndex = 0;
                        for (AbstractExampleSetJoin.AttributeSource attributeSource : originalAttributeSources) {
                            if (attributeSource.getSource() == 1) {
                                unionDataRow[attributeIndex] = attributeSource.getAttribute() == leftIdAttribute ? rightExample.getValue(rightIdAttribute) : Double.NaN;
                            } else if (attributeSource.getSource() == 2) {
                                unionDataRow[attributeIndex] = rightExample.getValue(attributeSource.getAttribute());
                            }
                            ++attributeIndex;
                        }
                        unionTable.addDataRow(new DoubleArrayDataRow(unionDataRow));
                    }
                    this.checkForStop();
                }
                break;
            }
            case 3: {
                HashSet<Integer> mappedRightExampleIndices = new HashSet<Integer>();
                for (Example leftExample : leftExampleSet) {
                    double leftIdValue = leftExample.getValue(leftIdAttribute);
                    int[] rightExampleIndices = null;
                    rightExampleIndices = leftIdAttribute.isNominal() ? rightExampleSet.getExampleIndicesFromId(rightIdAttribute.getMapping().getIndex(leftIdAttribute.getMapping().mapIndex((int)leftIdValue))) : rightExampleSet.getExampleIndicesFromId(leftIdValue);
                    if (rightExampleIndices != null) {
                        for (int rightExampleIndex : rightExampleIndices) {
                            mappedRightExampleIndices.add(rightExampleIndex);
                            Example rightExample = rightExampleSet.getExample(rightExampleIndex);
                            double[] unionDataRow = new double[unionAttributeList.size()];
                            int attributeIndex = 0;
                            for (AbstractExampleSetJoin.AttributeSource attributeSource : originalAttributeSources) {
                                if (attributeSource.getSource() == 1) {
                                    unionDataRow[attributeIndex] = leftExample.getValue(attributeSource.getAttribute());
                                } else if (attributeSource.getSource() == 2) {
                                    unionDataRow[attributeIndex] = rightExample.getValue(attributeSource.getAttribute());
                                }
                                ++attributeIndex;
                            }
                            unionTable.addDataRow(new DoubleArrayDataRow(unionDataRow));
                        }
                    } else {
                        double[] unionDataRow = new double[unionAttributeList.size()];
                        int attributeIndex = 0;
                        for (AbstractExampleSetJoin.AttributeSource attributeSource : originalAttributeSources) {
                            if (attributeSource.getSource() == 1) {
                                unionDataRow[attributeIndex] = leftExample.getValue(attributeSource.getAttribute());
                            } else if (attributeSource.getSource() == 2) {
                                unionDataRow[attributeIndex] = Double.NaN;
                            }
                            ++attributeIndex;
                        }
                        unionTable.addDataRow(new DoubleArrayDataRow(unionDataRow));
                    }
                    this.checkForStop();
                }
                int rightExampleIndex = 0;
                for (Example rightExample : rightExampleSet) {
                    if (!mappedRightExampleIndices.contains(rightExampleIndex)) {
                        double[] unionDataRow = new double[unionAttributeList.size()];
                        int attributeIndex = 0;
                        for (AbstractExampleSetJoin.AttributeSource attributeSource : originalAttributeSources) {
                            if (attributeSource.getSource() == 1) {
                                unionDataRow[attributeIndex] = attributeSource.getAttribute() == leftIdAttribute ? rightExample.getValue(rightIdAttribute) : Double.NaN;
                            } else if (attributeSource.getSource() == 2) {
                                unionDataRow[attributeIndex] = rightExample.getValue(attributeSource.getAttribute());
                            }
                            ++attributeIndex;
                        }
                        unionTable.addDataRow(new DoubleArrayDataRow(unionDataRow));
                    }
                    ++rightExampleIndex;
                    this.checkForStop();
                }
                break;
            }
        }
        return unionTable;
    }

    @Override
    protected boolean isIdNeeded() {
        return true;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeCategory(PARAMETER_JOIN_TYPE, "Specifies which join should be executed.", JOIN_TYPES, 0, false));
        return types;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator((InputPort)this.getInputPorts().getPortByIndex(0), ExampleSetJoin.class, null);
    }
}

