/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.join;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.MappedExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetPrecondition;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.preprocessing.AbstractDataProcessing;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.Ontology;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import java.util.LinkedList;

public class ExampleSetIntersect
extends AbstractDataProcessing {
    private InputPort secondInput = (InputPort)this.getInputPorts().createPort("second");

    public ExampleSetIntersect(OperatorDescription description) {
        super(description);
        this.secondInput.addPrecondition(new ExampleSetPrecondition(this.secondInput, 0, "id"));
    }

    @Override
    protected MetaData modifyMetaData(ExampleSetMetaData metaData) throws UndefinedParameterError {
        metaData.getNumberOfExamples().reduceByUnknownAmount();
        return metaData;
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        ExampleSet secondSet = (ExampleSet)this.secondInput.getData();
        ExampleSet firstSet = exampleSet;
        secondSet.remapIds();
        firstSet.remapIds();
        Attribute firstId = firstSet.getAttributes().getId();
        Attribute secondId = secondSet.getAttributes().getId();
        if (firstId == null || secondId == null) {
            throw new UserError((Operator)this, 129);
        }
        if (firstId.getValueType() != secondId.getValueType()) {
            throw new UserError((Operator)this, 120, secondId.getName(), Ontology.VALUE_TYPE_NAMES[secondId.getValueType()], Ontology.VALUE_TYPE_NAMES[firstId.getValueType()]);
        }
        LinkedList<Integer> indices = new LinkedList<Integer>();
        int i = 0;
        for (Example firstExample : firstSet) {
            double id = firstExample.getValue(firstId);
            Example secondExample = null;
            secondExample = firstId.isNominal() ? secondSet.getExampleFromId(secondId.getMapping().getIndex(firstId.getMapping().mapIndex((int)id))) : secondSet.getExampleFromId(id);
            if (secondExample != null) {
                indices.add(i);
            }
            ++i;
        }
        int[] indexArray = new int[indices.size()];
        for (int i2 = 0; i2 < indices.size(); ++i2) {
            indexArray[i2] = (Integer)indices.get(i2);
        }
        return new MappedExampleSet(firstSet, indexArray);
    }

    @Override
    public boolean writesIntoExistingData() {
        return false;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), ExampleSetIntersect.class, null);
    }
}

