/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.join;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.preprocessing.join.AbstractExampleSetJoin;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import java.util.Iterator;
import java.util.List;

public class ExampleSetCartesian
extends AbstractExampleSetJoin {
    public ExampleSetCartesian(OperatorDescription description) {
        super(description);
    }

    @Override
    protected MemoryExampleTable joinData(ExampleSet es1, ExampleSet es2, List<AbstractExampleSetJoin.AttributeSource> originalAttributeSources, List<Attribute> unionAttributeList) throws OperatorException {
        MemoryExampleTable unionTable = new MemoryExampleTable(unionAttributeList);
        for (Example example1 : es1) {
            for (Example example2 : es2) {
                double[] unionDataRow = new double[unionAttributeList.size()];
                Iterator<AbstractExampleSetJoin.AttributeSource> a = originalAttributeSources.iterator();
                int index = 0;
                while (a.hasNext()) {
                    AbstractExampleSetJoin.AttributeSource source = a.next();
                    if (source.getSource() == 1) {
                        unionDataRow[index] = example1.getValue(source.getAttribute());
                    } else if (source.getSource() == 2) {
                        unionDataRow[index] = example2.getValue(source.getAttribute());
                    }
                    ++index;
                }
                unionTable.addDataRow(new DoubleArrayDataRow(unionDataRow));
                this.checkForStop();
            }
        }
        return unionTable;
    }

    @Override
    protected boolean isIdNeeded() {
        return false;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator((InputPort)this.getInputPorts().getPortByIndex(0), ExampleSetCartesian.class, null);
    }
}

