/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.join;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.ExampleSetPrecondition;
import com.rapidminer.operator.ports.metadata.ExampleSetUnionRule;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.tools.Ontology;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractExampleSetJoin
extends Operator {
    private InputPort leftInput = (InputPort)this.getInputPorts().createPort("left");
    private InputPort rightInput = (InputPort)this.getInputPorts().createPort("right");
    private OutputPort joinOutput = (OutputPort)this.getOutputPorts().createPort("join");
    public static final String PARAMETER_REMOVE_DOUBLE_ATTRIBUTES = "remove_double_attributes";

    public AbstractExampleSetJoin(OperatorDescription description) {
        super(description);
        this.leftInput.addPrecondition(new ExampleSetPrecondition(this.leftInput, 0, "id"));
        this.rightInput.addPrecondition(new ExampleSetPrecondition(this.rightInput, 0, "id"));
        this.getTransformer().addRule(new ExampleSetUnionRule(this.rightInput, this.leftInput, this.joinOutput, "_from_ES2"){

            @Override
            protected String getPrefix() {
                return AbstractExampleSetJoin.this.getParameterAsBoolean(AbstractExampleSetJoin.PARAMETER_REMOVE_DOUBLE_ATTRIBUTES) ? null : "_from_ES2";
            }
        });
    }

    protected abstract MemoryExampleTable joinData(ExampleSet var1, ExampleSet var2, List<AttributeSource> var3, List<Attribute> var4) throws OperatorException;

    protected abstract boolean isIdNeeded();

    @Override
    public void doWork() throws OperatorException {
        AttributeRole role;
        ExampleSet es2 = (ExampleSet)this.leftInput.getData();
        ExampleSet es1 = (ExampleSet)this.rightInput.getData();
        if (this.isIdNeeded()) {
            Attribute id1 = es1.getAttributes().getId();
            Attribute id2 = es2.getAttributes().getId();
            if (id1 == null || id2 == null) {
                throw new UserError((Operator)this, 129);
            }
            if (!Ontology.ATTRIBUTE_VALUE_TYPE.isA(id1.getValueType(), id2.getValueType()) && !Ontology.ATTRIBUTE_VALUE_TYPE.isA(id2.getValueType(), id1.getValueType())) {
                throw new UserError((Operator)this, 120, id2.getName(), Ontology.VALUE_TYPE_NAMES[id2.getValueType()], Ontology.VALUE_TYPE_NAMES[id1.getValueType()]);
            }
        }
        LinkedList<AttributeSource> originalAttributeSources = new LinkedList<AttributeSource>();
        LinkedList<Attribute> unionAttributeList = new LinkedList<Attribute>();
        for (Attribute attribute : es1.getAttributes()) {
            originalAttributeSources.add(new AttributeSource(1, attribute));
            unionAttributeList.add((Attribute)attribute.clone());
        }
        for (Attribute attribute : es2.getAttributes()) {
            Attribute cloneAttribute = (Attribute)attribute.clone();
            if (this.containsAttribute(unionAttributeList, attribute)) {
                if (this.getParameterAsBoolean(PARAMETER_REMOVE_DOUBLE_ATTRIBUTES)) continue;
                originalAttributeSources.add(new AttributeSource(2, attribute));
                cloneAttribute.setName(cloneAttribute.getName() + "_from_ES2");
                if (this.containsAttribute(unionAttributeList, cloneAttribute)) {
                    cloneAttribute.setName(cloneAttribute.getName() + "_from_ES2");
                }
                unionAttributeList.add(cloneAttribute);
                continue;
            }
            originalAttributeSources.add(new AttributeSource(2, attribute));
            unionAttributeList.add(cloneAttribute);
        }
        HashMap<Attribute, String> unionSpecialAttributes = new HashMap<Attribute, String>();
        HashSet<String> usedSpecialAttributes = new HashSet<String>();
        Iterator<AttributeRole> s = es1.getAttributes().specialAttributes();
        while (s.hasNext()) {
            role = s.next();
            Attribute specialAttribute = role.getAttribute();
            Attribute specialAttributeClone = (Attribute)specialAttribute.clone();
            originalAttributeSources.add(new AttributeSource(1, specialAttribute));
            unionAttributeList.add(specialAttributeClone);
            unionSpecialAttributes.put(specialAttributeClone, role.getSpecialName());
            usedSpecialAttributes.add(role.getSpecialName());
        }
        s = es2.getAttributes().specialAttributes();
        while (s.hasNext()) {
            role = s.next();
            String specialName = role.getSpecialName();
            Attribute specialAttribute = role.getAttribute();
            if (!usedSpecialAttributes.contains(specialName)) {
                originalAttributeSources.add(new AttributeSource(2, specialAttribute));
                Attribute specialAttributeClone = (Attribute)specialAttribute.clone();
                unionAttributeList.add(specialAttributeClone);
                unionSpecialAttributes.put(specialAttributeClone, specialName);
                usedSpecialAttributes.add(specialName);
                continue;
            }
            this.logWarning("Special attribute '" + specialName + "' already exist, skipping!");
        }
        MemoryExampleTable unionTable = this.joinData(es1, es2, originalAttributeSources, unionAttributeList);
        this.joinOutput.deliver(unionTable.createExampleSet(unionSpecialAttributes));
    }

    public boolean containsAttribute(List<Attribute> attributeList, Attribute attribute) {
        Iterator<Attribute> i = attributeList.iterator();
        while (i.hasNext()) {
            if (!i.next().getName().equals(attribute.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean(PARAMETER_REMOVE_DOUBLE_ATTRIBUTES, "Indicates if double attributes should be removed or renamed", true));
        return types;
    }

    protected static class AttributeSource {
        protected static final int FIRST_SOURCE = 1;
        protected static final int SECOND_SOURCE = 2;
        protected int source;
        protected Attribute attribute;

        public AttributeSource(int source, Attribute attribute) {
            this.source = source;
            this.attribute = attribute;
        }

        protected int getSource() {
            return this.source;
        }

        protected Attribute getAttribute() {
            return this.attribute;
        }
    }
}

