/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter.attributes;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.set.ConditionCreationException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.MetaDataInfo;
import com.rapidminer.operator.preprocessing.filter.attributes.AbstractAttributeFilterCondition;
import com.rapidminer.operator.preprocessing.filter.attributes.AttributeFilterCondition;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.tools.Ontology;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;

public class ValueTypeAttributeFilter
extends AbstractAttributeFilterCondition {
    public static final String PARAMETER_VALUE_TYPE = "value_type";
    public static final String PARAMETER_ADD_EXCEPTION = "use_value_type_exception";
    public static final String PARAMETER_EXCEPT_VALUE_TYPE = "except_value_type";
    private int valueType;
    private int exceptValueType;

    @Override
    public void init(ParameterHandler operator) throws UserError, ConditionCreationException {
        this.valueType = Ontology.ATTRIBUTE_VALUE_TYPE.mapName(operator.getParameterAsString(PARAMETER_VALUE_TYPE));
        if (this.valueType < 0 || this.valueType >= Ontology.VALUE_TYPE_NAMES.length) {
            throw new ConditionCreationException("Unknown value type selected.");
        }
        String exceptValueTypeName = operator.getParameterAsString(PARAMETER_EXCEPT_VALUE_TYPE);
        if (operator.getParameterAsBoolean(PARAMETER_ADD_EXCEPTION)) {
            this.exceptValueType = Ontology.ATTRIBUTE_VALUE_TYPE.mapName(exceptValueTypeName);
            if (this.valueType < 0 || this.valueType >= Ontology.VALUE_TYPE_NAMES.length) {
                throw new ConditionCreationException("Unknown value type selected.");
            }
        } else {
            this.exceptValueType = -1;
        }
    }

    @Override
    public MetaDataInfo isFilteredOutMetaData(AttributeMetaData attribute, ParameterHandler handler) throws ConditionCreationException {
        if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), this.valueType)) {
            if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), this.exceptValueType)) {
                return MetaDataInfo.YES;
            }
            return MetaDataInfo.NO;
        }
        return MetaDataInfo.YES;
    }

    @Override
    public AttributeFilterCondition.ScanResult beforeScanCheck(Attribute attribute) throws UserError {
        if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), this.valueType)) {
            if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), this.exceptValueType)) {
                return AttributeFilterCondition.ScanResult.REMOVE;
            }
            return AttributeFilterCondition.ScanResult.KEEP;
        }
        return AttributeFilterCondition.ScanResult.REMOVE;
    }

    @Override
    public List<ParameterType> getParameterTypes(ParameterHandler operator, InputPort inPort, int ... valueTypes) {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        LinkedHashSet<String> valueTypeSet = new LinkedHashSet<String>();
        for (String valueTypeName : Ontology.ATTRIBUTE_VALUE_TYPE.getNames()) {
            int valueType = Ontology.ATTRIBUTE_VALUE_TYPE.mapName(valueTypeName);
            for (int parent : valueTypes) {
                if (!Ontology.ATTRIBUTE_VALUE_TYPE.isA(valueType, parent)) continue;
                valueTypeSet.add(Ontology.ATTRIBUTE_VALUE_TYPE.mapIndex(valueType));
            }
        }
        String[] valueTypeNames = new String[valueTypeSet.size()];
        valueTypeNames = valueTypeSet.toArray(valueTypeNames);
        String[] exceptValueTypeNames = new String[valueTypeSet.size()];
        exceptValueTypeNames = valueTypeSet.toArray(valueTypeNames);
        types.add(new ParameterTypeCategory(PARAMETER_VALUE_TYPE, "The value type of the attributes.", valueTypeNames, 0, false));
        types.add(new ParameterTypeBoolean(PARAMETER_ADD_EXCEPTION, "If enabled, an exception to the specified value type might be specified. Attributes of this type will be filtered out, although matching the first specified type.", false, true));
        ParameterTypeCategory type = new ParameterTypeCategory(PARAMETER_EXCEPT_VALUE_TYPE, "Except this value type.", exceptValueTypeNames, exceptValueTypeNames.length - 1, true);
        type.registerDependencyCondition(new BooleanParameterCondition(operator, PARAMETER_ADD_EXCEPTION, true, true));
        types.add(type);
        return types;
    }
}

