/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter.attributes;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.set.ConditionCreationException;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.MetaDataInfo;
import com.rapidminer.operator.preprocessing.filter.attributes.AbstractAttributeFilterCondition;
import com.rapidminer.operator.preprocessing.filter.attributes.AttributeFilterCondition;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttributes;
import java.util.LinkedList;
import java.util.List;

public class SubsetAttributeFilter
extends AbstractAttributeFilterCondition {
    public static final String PARAMETER_ATTRIBUTES = "attributes";
    private String attributeNames;

    @Override
    public void init(ParameterHandler operator) throws UserError, ConditionCreationException {
        this.attributeNames = operator.getParameterAsString(PARAMETER_ATTRIBUTES);
        if (this.attributeNames == null || this.attributeNames.length() == 0) {
            throw new UserError(operator instanceof Operator ? (Operator)operator : null, 904, "The condition for a single attribute needs a non-empty attributes parameter string.");
        }
    }

    @Override
    public MetaDataInfo isFilteredOutMetaData(AttributeMetaData attribute, ParameterHandler handler) throws ConditionCreationException {
        if (this.attributeNames == null || this.attributeNames.length() == 0) {
            throw new ConditionCreationException("The condition for a single attribute needs a non-empty attribute parameter string.");
        }
        boolean found = false;
        for (String attributeName : this.attributeNames.split("\\|")) {
            if (!attribute.getName().equals(attributeName)) continue;
            found = true;
        }
        return found ? MetaDataInfo.NO : MetaDataInfo.YES;
    }

    @Override
    public AttributeFilterCondition.ScanResult beforeScanCheck(Attribute attribute) throws UserError {
        for (String attributeName : this.attributeNames.split("\\|")) {
            if (!attribute.getName().equals(attributeName)) continue;
            return AttributeFilterCondition.ScanResult.KEEP;
        }
        return AttributeFilterCondition.ScanResult.REMOVE;
    }

    @Override
    public List<ParameterType> getParameterTypes(ParameterHandler operator, InputPort inPort, int ... valueTypes) {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        ParameterTypeAttributes type = new ParameterTypeAttributes(PARAMETER_ATTRIBUTES, "The attribute which should be chosen.", inPort, valueTypes);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

