/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter.attributes;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.set.ConditionCreationException;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.MetaDataInfo;
import com.rapidminer.operator.preprocessing.filter.attributes.AbstractAttributeFilterCondition;
import com.rapidminer.operator.preprocessing.filter.attributes.AttributeFilterCondition;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import java.util.LinkedList;
import java.util.List;

public class SingleAttributeFilter
extends AbstractAttributeFilterCondition {
    public static final String PARAMETER_ATTRIBUTE = "attribute";
    private String attributeName;

    @Override
    public void init(ParameterHandler operator) throws UserError, ConditionCreationException {
        this.attributeName = operator.getParameterAsString(PARAMETER_ATTRIBUTE);
        if (this.attributeName == null || this.attributeName.length() == 0) {
            throw new UserError(operator instanceof Operator ? (Operator)operator : null, 904, "The condition for a single attribute needs a non-empty attribute parameter string.");
        }
    }

    @Override
    public MetaDataInfo isFilteredOutMetaData(AttributeMetaData attribute, ParameterHandler handler) throws ConditionCreationException {
        if (this.attributeName == null || this.attributeName.length() == 0) {
            throw new ConditionCreationException("The condition for a single attribute needs a non-empty attribute parameter string.");
        }
        return attribute.getName().equals(this.attributeName) ? MetaDataInfo.NO : MetaDataInfo.YES;
    }

    @Override
    public AttributeFilterCondition.ScanResult beforeScanCheck(Attribute attribute) throws UserError {
        if (attribute.getName().equals(this.attributeName)) {
            return AttributeFilterCondition.ScanResult.KEEP;
        }
        return AttributeFilterCondition.ScanResult.REMOVE;
    }

    @Override
    public List<ParameterType> getParameterTypes(ParameterHandler operator, InputPort inPort, int ... valueTypes) {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        ParameterTypeAttribute type = new ParameterTypeAttribute(PARAMETER_ATTRIBUTE, "The attribute which should be chosen.", inPort, true, valueTypes);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

