/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter.attributes;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.set.ConditionCreationException;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.MetaDataInfo;
import com.rapidminer.operator.preprocessing.filter.attributes.AbstractAttributeFilterCondition;
import com.rapidminer.operator.preprocessing.filter.attributes.AttributeFilterCondition;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeRegexp;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.tools.Ontology;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.PatternSyntaxException;

public class RegexpAttributeFilter
extends AbstractAttributeFilterCondition {
    public static final String PARAMETER_REGULAR_EXPRESSION = "regular_expression";
    public static final String PARAMETER_ADD_EXCEPTION = "use_except_expression";
    public static final String PARAMETER_EXCEPT_REGULAR_EXPRESSION = "except_regular_expression";
    private String attributeNameRegexp;
    private String exceptRegexp = null;

    @Override
    public void init(ParameterHandler operator) throws UserError, ConditionCreationException {
        this.attributeNameRegexp = operator.getParameterAsString(PARAMETER_REGULAR_EXPRESSION);
        if (this.attributeNameRegexp == null || this.attributeNameRegexp.length() == 0) {
            throw new UserError(operator instanceof Operator ? (Operator)operator : null, 904, "The condition for attribute names needs a parameter string.");
        }
        if (operator.isParameterSet(PARAMETER_EXCEPT_REGULAR_EXPRESSION) && operator.getParameterAsBoolean(PARAMETER_ADD_EXCEPTION)) {
            this.exceptRegexp = operator.getParameterAsString(PARAMETER_EXCEPT_REGULAR_EXPRESSION);
        }
        if (this.exceptRegexp != null && this.exceptRegexp.length() == 0) {
            this.exceptRegexp = null;
        }
    }

    @Override
    public MetaDataInfo isFilteredOutMetaData(AttributeMetaData attribute, ParameterHandler handler) throws ConditionCreationException {
        try {
            if (attribute.getName().matches(this.attributeNameRegexp)) {
                if (this.exceptRegexp != null) {
                    if (attribute.getName().matches(this.exceptRegexp)) {
                        return MetaDataInfo.YES;
                    }
                    return MetaDataInfo.NO;
                }
                return MetaDataInfo.NO;
            }
            return MetaDataInfo.YES;
        }
        catch (PatternSyntaxException e) {
            return MetaDataInfo.UNKNOWN;
        }
    }

    @Override
    public AttributeFilterCondition.ScanResult beforeScanCheck(Attribute attribute) throws UserError {
        if (attribute.getName().matches(this.attributeNameRegexp)) {
            if (this.exceptRegexp != null && attribute.getName().matches(this.exceptRegexp)) {
                return AttributeFilterCondition.ScanResult.REMOVE;
            }
            return AttributeFilterCondition.ScanResult.KEEP;
        }
        return AttributeFilterCondition.ScanResult.REMOVE;
    }

    private boolean isOfAllowedType(int valueType, int[] allowedValueTypes) {
        boolean isAllowed = false;
        for (int type : allowedValueTypes) {
            isAllowed |= Ontology.ATTRIBUTE_VALUE_TYPE.isA(valueType, type);
        }
        return isAllowed;
    }

    @Override
    public List<ParameterType> getParameterTypes(ParameterHandler operator, final InputPort inPort, final int ... valueTypes) {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        types.add(new ParameterTypeRegexp(PARAMETER_REGULAR_EXPRESSION, "A regular expression for the names of the attributes which should be kept.", true, false){
            private static final long serialVersionUID = 8133149560984042644L;

            @Override
            public Collection<String> getPreviewList() {
                LinkedList<String> regExpPreviewList = new LinkedList<String>();
                if (inPort == null) {
                    return null;
                }
                MetaData metaData = inPort.getMetaData();
                if (metaData instanceof ExampleSetMetaData) {
                    ExampleSetMetaData emd = (ExampleSetMetaData)metaData;
                    for (AttributeMetaData amd : emd.getAllAttributes()) {
                        if (!RegexpAttributeFilter.this.isOfAllowedType(amd.getValueType(), valueTypes)) continue;
                        regExpPreviewList.add(amd.getName());
                    }
                }
                return regExpPreviewList;
            }
        });
        types.add(new ParameterTypeBoolean(PARAMETER_ADD_EXCEPTION, "If enabled, an exception to the specified regular expression might be specified. Attributes of matching this will be filtered out, although matching the first expression.", false, true));
        ParameterTypeRegexp type = new ParameterTypeRegexp(PARAMETER_EXCEPT_REGULAR_EXPRESSION, "A regular expression for the names of the attributes which should be filtered out although matching the above regular expression.", true, true){
            private static final long serialVersionUID = 81331495609840426L;

            @Override
            public Collection<String> getPreviewList() {
                LinkedList<String> regExpPreviewList = new LinkedList<String>();
                if (inPort == null) {
                    return null;
                }
                MetaData metaData = inPort.getMetaData();
                if (metaData instanceof ExampleSetMetaData) {
                    ExampleSetMetaData emd = (ExampleSetMetaData)metaData;
                    for (AttributeMetaData amd : emd.getAllAttributes()) {
                        if (!RegexpAttributeFilter.this.isOfAllowedType(amd.getValueType(), valueTypes)) continue;
                        regExpPreviewList.add(amd.getName());
                    }
                }
                return regExpPreviewList;
            }
        };
        type.setExpert(true);
        type.registerDependencyCondition(new BooleanParameterCondition(operator, PARAMETER_ADD_EXCEPTION, true, true));
        types.add(type);
        return types;
    }
}

