/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter.attributes;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.set.ConditionCreationException;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.MetaDataInfo;
import com.rapidminer.operator.preprocessing.filter.attributes.AbstractAttributeFilterCondition;
import com.rapidminer.operator.preprocessing.filter.attributes.AttributeFilterCondition;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class NumericValueAttributeFilter
extends AbstractAttributeFilterCondition {
    public static String PARAMETER_NUMERIC_CONDITION = "numeric_condition";
    private Attribute lastCheckedAttribute = null;
    private ArrayList<Condition> conditions;
    private boolean keep = true;
    private boolean conjunctiveMode;

    @Override
    public void init(ParameterHandler parameterHandler) throws UserError, ConditionCreationException {
        String conditionString = parameterHandler.getParameterAsString(PARAMETER_NUMERIC_CONDITION);
        Operator operator = null;
        if (parameterHandler instanceof Operator) {
            operator = (Operator)parameterHandler;
        }
        if (conditionString == null || conditionString.length() == 0) {
            throw new UserError(operator, 904, "The condition for numerical values needs a parameter string.");
        }
        if (conditionString.contains("||") && conditionString.contains("&&")) {
            throw new UserError(operator, 904, "|| and && not allowed in one condition");
        }
        this.conjunctiveMode = conditionString.contains("&&");
        this.conditions = new ArrayList();
        for (String conditionSubString : conditionString.split("[|&]{2}")) {
            String[] parts = conditionSubString.trim().split("\\s+");
            if (parts.length != 2) {
                throw new UserError(operator, 904, "number of condition arguments not correct");
            }
            this.conditions.add(new Condition(parts[0], parts[1]));
        }
    }

    @Override
    public MetaDataInfo isFilteredOutMetaData(AttributeMetaData attribute, ParameterHandler handler) {
        return MetaDataInfo.UNKNOWN;
    }

    @Override
    public boolean isNeedingScan() {
        return true;
    }

    @Override
    public AttributeFilterCondition.ScanResult beforeScanCheck(Attribute attribute) throws UserError {
        return AttributeFilterCondition.ScanResult.UNCHECKED;
    }

    @Override
    public AttributeFilterCondition.ScanResult check(Attribute attribute, Example example) {
        if (this.lastCheckedAttribute != attribute) {
            this.keep = true;
        }
        if (attribute.isNumerical()) {
            boolean exampleResult;
            double checkValue = example.getValue(attribute);
            if (this.conjunctiveMode) {
                exampleResult = true;
                for (Condition condition : this.conditions) {
                    exampleResult &= condition.check(checkValue);
                }
            } else {
                exampleResult = false;
                for (Condition condition : this.conditions) {
                    exampleResult |= condition.check(checkValue);
                }
            }
            this.keep &= exampleResult;
        }
        if (!this.keep && attribute.isNumerical()) {
            return AttributeFilterCondition.ScanResult.REMOVE;
        }
        return AttributeFilterCondition.ScanResult.UNCHECKED;
    }

    @Override
    public List<ParameterType> getParameterTypes(ParameterHandler operator, InputPort inPort, int ... valueTypes) {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        types.add(new ParameterTypeString(PARAMETER_NUMERIC_CONDITION, "Parameter string for the condition, e.g. '>= 5'", true, false));
        return types;
    }

    private static class Condition {
        private int condition;
        private double value;

        public Condition(String condition, String value) {
            this.value = Double.parseDouble(value);
            if (condition.equals("<>") || condition.equals("!=")) {
                this.condition = 1;
            } else if (condition.equals("<=")) {
                this.condition = 2;
            } else if (condition.equals("<")) {
                this.condition = 3;
            } else if (condition.equals(">=")) {
                this.condition = 4;
            } else if (condition.equals(">")) {
                this.condition = 5;
            } else if (condition.equals("=")) {
                this.condition = 0;
            }
        }

        public boolean check(double value) {
            if (Double.isNaN(value)) {
                return true;
            }
            switch (this.condition) {
                case 0: {
                    return value == this.value;
                }
                case 1: {
                    return value != this.value;
                }
                case 2: {
                    return value <= this.value;
                }
                case 3: {
                    return value < this.value;
                }
                case 4: {
                    return value >= this.value;
                }
                case 5: {
                    return value > this.value;
                }
            }
            return false;
        }
    }
}

