/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter.attributes;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.MetaDataInfo;
import com.rapidminer.operator.preprocessing.filter.attributes.AbstractAttributeFilterCondition;
import com.rapidminer.operator.preprocessing.filter.attributes.AttributeFilterCondition;
import com.rapidminer.parameter.ParameterHandler;

public class NoMissingValuesAttributeFilter
extends AbstractAttributeFilterCondition {
    @Override
    public MetaDataInfo isFilteredOutMetaData(AttributeMetaData attribute, ParameterHandler handler) {
        switch (attribute.containsMissingValues()) {
            case YES: {
                return MetaDataInfo.YES;
            }
            case NO: {
                return MetaDataInfo.NO;
            }
        }
        return MetaDataInfo.UNKNOWN;
    }

    @Override
    public boolean isNeedingScan() {
        return true;
    }

    @Override
    public AttributeFilterCondition.ScanResult beforeScanCheck(Attribute attribute) {
        return AttributeFilterCondition.ScanResult.UNCHECKED;
    }

    @Override
    public AttributeFilterCondition.ScanResult check(Attribute attribute, Example example) {
        if (Double.isNaN(example.getValue(attribute))) {
            return AttributeFilterCondition.ScanResult.REMOVE;
        }
        return AttributeFilterCondition.ScanResult.UNCHECKED;
    }
}

