/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter.attributes;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.set.ConditionCreationException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.MetaDataInfo;
import com.rapidminer.operator.preprocessing.filter.attributes.AbstractAttributeFilterCondition;
import com.rapidminer.operator.preprocessing.filter.attributes.AttributeFilterCondition;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeDouble;
import java.util.List;

public class MissingValuesAttributeFilter
extends AbstractAttributeFilterCondition {
    public static final String PARAMETER_MAX_FRACTION_MISSING = "max_fraction_of_missings";
    private double maxFraction;
    private int numberOfExamples = 0;
    private int numberOfMissings = 0;
    private Attribute lastAttribute = null;

    @Override
    public MetaDataInfo isFilteredOutMetaData(AttributeMetaData attribute, ParameterHandler parameterHandler) throws ConditionCreationException {
        return MetaDataInfo.UNKNOWN;
    }

    @Override
    public boolean isNeedingFullScan() {
        return true;
    }

    @Override
    public boolean isNeedingScan() {
        return true;
    }

    @Override
    public AttributeFilterCondition.ScanResult beforeScanCheck(Attribute attribute) throws UserError {
        return AttributeFilterCondition.ScanResult.UNCHECKED;
    }

    @Override
    public AttributeFilterCondition.ScanResult check(Attribute attribute, Example example) {
        if (attribute != this.lastAttribute) {
            this.numberOfExamples = 0;
            this.numberOfMissings = 0;
            this.lastAttribute = attribute;
        }
        ++this.numberOfExamples;
        if (Double.isNaN(example.getValue(attribute))) {
            ++this.numberOfMissings;
        }
        return AttributeFilterCondition.ScanResult.UNCHECKED;
    }

    @Override
    public AttributeFilterCondition.ScanResult checkAfterFullScan() {
        double fraction = this.numberOfExamples;
        if ((double)this.numberOfMissings / fraction > this.maxFraction) {
            return AttributeFilterCondition.ScanResult.REMOVE;
        }
        return AttributeFilterCondition.ScanResult.KEEP;
    }

    @Override
    public void init(ParameterHandler operator) throws UserError, ConditionCreationException {
        this.maxFraction = operator.getParameterAsDouble(PARAMETER_MAX_FRACTION_MISSING);
    }

    @Override
    public List<ParameterType> getParameterTypes(ParameterHandler operator, InputPort inPort, int ... valueTypes) {
        List<ParameterType> types = super.getParameterTypes(operator, inPort, new int[0]);
        types.add(new ParameterTypeDouble(PARAMETER_MAX_FRACTION_MISSING, "If the attribute contains missing values in more than this fraction of the total number of examples, it is removed.", 0.0, 1.0, true));
        return types;
    }
}

