/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter.attributes;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.set.ConditionCreationException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.MetaDataInfo;
import com.rapidminer.operator.preprocessing.filter.attributes.AbstractAttributeFilterCondition;
import com.rapidminer.operator.preprocessing.filter.attributes.AttributeFilterCondition;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.tools.Ontology;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;

public class BlockTypeAttributeFilter
extends AbstractAttributeFilterCondition {
    public static final String PARAMETER_BLOCK_TYPE = "block_type";
    public static final String PARAMETER_ADD_EXCEPTION = "use_block_type_exception";
    public static final String PARAMETER_EXCEPT_BLOCK_TYPE = "except_block_type";
    private int blockType;
    private int exceptBlockType;

    @Override
    public void init(ParameterHandler operator) throws UserError, ConditionCreationException {
        this.blockType = Ontology.ATTRIBUTE_BLOCK_TYPE.mapName(operator.getParameterAsString(PARAMETER_BLOCK_TYPE));
        if (this.blockType < 0 || this.blockType >= Ontology.BLOCK_TYPE_NAMES.length) {
            throw new ConditionCreationException("Unknown value type selected.");
        }
        String exceptValueTypeName = operator.getParameterAsString(PARAMETER_EXCEPT_BLOCK_TYPE);
        if (operator.getParameterAsBoolean(PARAMETER_ADD_EXCEPTION)) {
            this.exceptBlockType = Ontology.ATTRIBUTE_BLOCK_TYPE.mapName(exceptValueTypeName);
            if (this.blockType < 0 || this.blockType >= Ontology.BLOCK_TYPE_NAMES.length) {
                throw new ConditionCreationException("Unknown value type selected.");
            }
        } else {
            this.exceptBlockType = -1;
        }
    }

    @Override
    public MetaDataInfo isFilteredOutMetaData(AttributeMetaData attribute, ParameterHandler handler) throws ConditionCreationException {
        return MetaDataInfo.UNKNOWN;
    }

    @Override
    public AttributeFilterCondition.ScanResult beforeScanCheck(Attribute attribute) throws UserError {
        if (Ontology.ATTRIBUTE_BLOCK_TYPE.isA(attribute.getValueType(), this.blockType)) {
            if (this.exceptBlockType > 0 && Ontology.ATTRIBUTE_BLOCK_TYPE.isA(attribute.getValueType(), this.exceptBlockType)) {
                return AttributeFilterCondition.ScanResult.REMOVE;
            }
            return AttributeFilterCondition.ScanResult.KEEP;
        }
        return AttributeFilterCondition.ScanResult.REMOVE;
    }

    @Override
    public List<ParameterType> getParameterTypes(ParameterHandler operator, InputPort inPort, int ... valueTypes) {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        LinkedHashSet<String> valueTypeSet = new LinkedHashSet<String>();
        for (String valueTypeName : Ontology.ATTRIBUTE_BLOCK_TYPE.getNames()) {
            int valueType = Ontology.ATTRIBUTE_BLOCK_TYPE.mapName(valueTypeName);
            for (int parent : valueTypes) {
                if (!Ontology.ATTRIBUTE_BLOCK_TYPE.isA(valueType, parent)) continue;
                valueTypeSet.add(Ontology.ATTRIBUTE_BLOCK_TYPE.mapIndex(valueType));
            }
        }
        String[] valueTypeNames = new String[valueTypeSet.size()];
        valueTypeNames = valueTypeSet.toArray(valueTypeNames);
        String[] exceptValueTypeNames = new String[valueTypeSet.size()];
        exceptValueTypeNames = valueTypeSet.toArray(valueTypeNames);
        types.add(new ParameterTypeCategory(PARAMETER_BLOCK_TYPE, "The block type of the attributes.", valueTypeNames, 0, false));
        types.add(new ParameterTypeBoolean(PARAMETER_ADD_EXCEPTION, "If enabled, an exception to the specified block type might be specified.", false, true));
        ParameterTypeCategory type = new ParameterTypeCategory(PARAMETER_EXCEPT_BLOCK_TYPE, "Except this block type.", exceptValueTypeNames, exceptValueTypeNames.length - 1, true);
        type.registerDependencyCondition(new BooleanParameterCondition(operator, PARAMETER_ADD_EXCEPTION, true, true));
        types.add(type);
        return types;
    }
}

