/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter.attributes;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.features.selection.AbstractFeatureSelection;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.tools.AttributeSubsetSelector;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class AttributeFilter
extends AbstractFeatureSelection {
    private final AttributeSubsetSelector attributeSelector = new AttributeSubsetSelector(this, this.getExampleSetInputPort());

    public AttributeFilter(OperatorDescription description) {
        super(description);
    }

    @Override
    protected MetaData modifyMetaData(ExampleSetMetaData metaData) {
        ExampleSetMetaData subset = this.attributeSelector.getMetaDataSubset(metaData, true);
        Iterator<AttributeMetaData> amdIterator = metaData.getAllAttributes().iterator();
        while (amdIterator.hasNext()) {
            AttributeMetaData amd = amdIterator.next();
            AttributeMetaData subsetAMD = subset.getAttributeByName(amd.getName());
            if (subsetAMD != null) continue;
            amdIterator.remove();
        }
        return metaData;
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        Attributes attributes = exampleSet.getAttributes();
        Set<Attribute> attributeSubset = this.attributeSelector.getAttributeSubset(exampleSet, true);
        Iterator<Attribute> r = attributes.allAttributes();
        while (r.hasNext()) {
            Attribute attribute = r.next();
            if (attributeSubset.contains(attribute)) continue;
            r.remove();
        }
        return exampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.addAll(this.attributeSelector.getParameterTypes());
        return types;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), AttributeFilter.class, this.attributeSelector);
    }
}

