/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.ViewAttribute;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.preprocessing.PreprocessingModel;
import java.util.HashMap;
import java.util.Iterator;

public class ValueReplenishmentModel
extends PreprocessingModel {
    private static final long serialVersionUID = -4886756106998999255L;
    private HashMap<String, Double> numericalReplacementMap;
    private HashMap<String, String> nominalReplacementMap;
    private double replaceWhat;
    private HashMap<Attribute, Double> attributeReplacementMap = new HashMap();

    public ValueReplenishmentModel(ExampleSet exampleSet, double replacedValue, HashMap<String, Double> numericalReplacementMap, HashMap<String, String> nominalReplacementMap) {
        super(exampleSet);
        this.replaceWhat = replacedValue;
        this.nominalReplacementMap = nominalReplacementMap;
        this.numericalReplacementMap = numericalReplacementMap;
    }

    @Override
    public ExampleSet applyOnData(ExampleSet exampleSet) throws OperatorException {
        Attributes attributes = exampleSet.getAttributes();
        boolean[] replace = new boolean[attributes.size()];
        double[] by = new double[attributes.size()];
        int i = 0;
        for (Attribute attribute : attributes) {
            Object replacement;
            if (attribute.isNominal() && (replacement = this.nominalReplacementMap.get(attribute.getName())) != null) {
                replace[i] = true;
                by[i] = attribute.getMapping().mapString((String)replacement);
            }
            if (attribute.isNumerical() && (replacement = this.numericalReplacementMap.get(attribute.getName())) != null) {
                replace[i] = true;
                by[i] = (Double)replacement;
            }
            ++i;
        }
        for (Example example : exampleSet) {
            i = 0;
            for (Attribute attribute : attributes) {
                double value;
                if (replace[i] && ((value = example.getValue(attribute)) == this.replaceWhat || Double.isNaN(this.replaceWhat) && Double.isNaN(value))) {
                    example.setValue(attribute, by[i]);
                }
                ++i;
            }
        }
        return exampleSet;
    }

    @Override
    public Attributes getTargetAttributes(ExampleSet viewParent) {
        Attributes attributes = viewParent.getAttributes();
        int i = 0;
        Iterator<Attribute> iterator = attributes.allAttributes();
        while (iterator.hasNext()) {
            ViewAttribute viewAttribute;
            Object replacement;
            Attribute attribute = iterator.next();
            if (attribute.isNominal() && (replacement = this.nominalReplacementMap.get(attribute.getName())) != null) {
                viewAttribute = new ViewAttribute(this, attribute, attribute.getName(), attribute.getValueType(), attribute.getMapping());
                this.attributeReplacementMap.put(viewAttribute, Double.valueOf(attribute.getMapping().mapString((String)replacement)));
                iterator.remove();
            }
            if (attribute.isNumerical() && (replacement = this.numericalReplacementMap.get(attribute.getName())) != null) {
                viewAttribute = new ViewAttribute(this, attribute, attribute.getName(), attribute.getValueType(), null);
                this.attributeReplacementMap.put(viewAttribute, (Double)replacement);
                iterator.remove();
            }
            ++i;
        }
        for (Attribute attribute : this.attributeReplacementMap.keySet()) {
            attributes.addRegular(attribute);
        }
        return attributes;
    }

    @Override
    public double getValue(Attribute targetAttribute, double value) {
        if (this.replaceWhat == value || Double.isNaN(this.replaceWhat) && Double.isNaN(value)) {
            return this.attributeReplacementMap.get(targetAttribute);
        }
        return value;
    }
}

