/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.preprocessing.PreprocessingModel;
import com.rapidminer.operator.preprocessing.PreprocessingOperator;
import com.rapidminer.operator.preprocessing.filter.ValueReplenishmentModel;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeStringCategory;
import com.rapidminer.parameter.UndefinedParameterError;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public abstract class ValueReplenishment
extends PreprocessingOperator {
    public static final String PARAMETER_DEFAULT = "default";
    public static final String PARAMETER_COLUMNS = "columns";

    public ValueReplenishment(OperatorDescription description) {
        super(description);
    }

    public abstract double getReplacedValue();

    public abstract double getReplenishmentValue(int var1, ExampleSet var2, Attribute var3) throws UndefinedParameterError, UserError;

    public abstract String[] getFunctionNames();

    public abstract int getDefaultFunction();

    public abstract int getDefaultColumnFunction();

    @Override
    public PreprocessingModel createPreprocessingModel(ExampleSet exampleSet) throws OperatorException {
        exampleSet.recalculateAllAttributeStatistics();
        int defaultFunction = this.getParameterAsInt(PARAMETER_DEFAULT);
        List<String[]> functionList = this.getParameterList(PARAMETER_COLUMNS);
        double replacedValue = this.getReplacedValue();
        HashMap<String, Double> numericalReplacementMap = new HashMap<String, Double>();
        HashMap<String, String> nominalReplacementMap = new HashMap<String, String>();
        List<String> functionNames = Arrays.asList(this.getFunctionNames());
        for (Attribute attribute : exampleSet.getAttributes()) {
            String attributeName = attribute.getName();
            int function = defaultFunction;
            for (String[] pair : functionList) {
                if (!pair[0].equals(attributeName) || (function = functionNames.indexOf(pair[1])) != -1) continue;
                throw new RuntimeException("Illegal replacement function: " + pair[1]);
            }
            if (attribute.isNominal()) {
                nominalReplacementMap.put(attributeName, attribute.getMapping().mapIndex((int)this.getReplenishmentValue(function, exampleSet, attribute)));
            }
            if (!attribute.isNumerical()) continue;
            numericalReplacementMap.put(attributeName, this.getReplenishmentValue(function, exampleSet, attribute));
        }
        return new ValueReplenishmentModel(exampleSet, replacedValue, numericalReplacementMap, nominalReplacementMap);
    }

    @Override
    public Class<? extends PreprocessingModel> getPreprocessingModelClass() {
        return ValueReplenishmentModel.class;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        String[] functionNames = this.getFunctionNames();
        ParameterTypeCategory type = new ParameterTypeCategory(PARAMETER_DEFAULT, "Function to apply to all columns that are not explicitly specified by parameter 'columns'.", functionNames, this.getDefaultFunction());
        type.setExpert(false);
        types.add(type);
        ParameterTypeStringCategory categories = new ParameterTypeStringCategory("replace_with", "Selects the function, which is used to determine the replacement for the missing values of this attribute.", functionNames, this.getFunctionNames()[this.getDefaultColumnFunction()], false);
        categories.setEditable(false);
        types.add(new ParameterTypeList(PARAMETER_COLUMNS, "List of replacement functions for each column.", (ParameterType)new ParameterTypeAttribute("attribute", "Specifies the attribute, which missing values are replaced.", this.getExampleSetInputPort()), (ParameterType)categories));
        return types;
    }
}

