/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.preprocessing.filter.AbstractFilteredDataProcessing;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;

public class String2Nominal
extends AbstractFilteredDataProcessing {
    public String2Nominal(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet applyOnFiltered(ExampleSet exampleSet) throws OperatorException {
        for (Attribute attribute : exampleSet.getAttributes()) {
            if (!attribute.isNominal()) continue;
            Attribute newAttribute = AttributeFactory.changeValueType(attribute, 1);
            exampleSet.getAttributes().replace(attribute, newAttribute);
        }
        return exampleSet;
    }

    @Override
    public ExampleSetMetaData applyOnFilteredMetaData(ExampleSetMetaData emd) {
        for (AttributeMetaData amd : emd.getAllAttributes()) {
            if (!amd.isNominal()) continue;
            amd.setType(1);
        }
        return emd;
    }

    @Override
    protected int[] getFilterValueTypes() {
        return new int[]{5};
    }

    @Override
    public boolean writesIntoExistingData() {
        return false;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), String2Nominal.class, null);
    }
}

