/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.AttributeSetPrecondition;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.preprocessing.AbstractDataProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import java.util.List;

public class SetData
extends AbstractDataProcessing {
    public static final String PARAMETER_ATTRIBUTE_NAME = "attribute_name";
    public static final String PARAMETER_EXAMPLE_INDEX = "example_index";
    public static final String PARAMETER_COUNT_BACKWARDS = "count_backwards";
    public static final String PARAMETER_VALUE = "value";

    public SetData(OperatorDescription description) {
        super(description);
        this.getExampleSetInputPort().addPrecondition(new AttributeSetPrecondition(this.getExampleSetInputPort(), AttributeSetPrecondition.getAttributesByParameter(this, PARAMETER_ATTRIBUTE_NAME), new String[0]));
    }

    @Override
    protected MetaData modifyMetaData(ExampleSetMetaData metaData) throws UndefinedParameterError {
        AttributeMetaData targetAttribute = metaData.getAttributeByName(this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME));
        if (targetAttribute != null) {
            if (targetAttribute.isNominal()) {
                targetAttribute.getValueSet().add(this.getParameterAsString(PARAMETER_VALUE));
            } else {
                try {
                    targetAttribute.getValueRange().add(Double.parseDouble(this.getParameterAsString(PARAMETER_VALUE)));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return metaData;
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        String value = this.getParameterAsString(PARAMETER_VALUE);
        int exampleIndex = this.getParameterAsInt(PARAMETER_EXAMPLE_INDEX);
        if (exampleIndex == 0) {
            throw new UserError((Operator)this, 207, "0", PARAMETER_EXAMPLE_INDEX, "only positive or negative indices are allowed");
        }
        exampleIndex = this.getParameterAsBoolean(PARAMETER_COUNT_BACKWARDS) ? exampleSet.size() - exampleIndex : --exampleIndex;
        if (exampleIndex >= exampleSet.size()) {
            throw new UserError((Operator)this, 110, exampleIndex);
        }
        Attribute attribute = exampleSet.getAttributes().get(this.getParameter(PARAMETER_ATTRIBUTE_NAME));
        if (attribute == null) {
            throw new UserError((Operator)this, 111, this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME));
        }
        Example example = exampleSet.getExample(exampleIndex);
        if (attribute.isNominal()) {
            example.setValue(attribute, attribute.getMapping().mapString(value));
        } else {
            try {
                double doubleValue = Double.parseDouble(value);
                example.setValue(attribute, doubleValue);
            }
            catch (NumberFormatException e) {
                throw new UserError((Operator)this, 211, PARAMETER_VALUE, value);
            }
        }
        return exampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeAttribute(PARAMETER_ATTRIBUTE_NAME, "The name of the attribute for which the value should be set.", this.getExampleSetInputPort(), false));
        ParameterTypeInt type = new ParameterTypeInt(PARAMETER_EXAMPLE_INDEX, "The index of the example for which the value should be set. Counting starts at 1.", 1, Integer.MAX_VALUE, false);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_COUNT_BACKWARDS, "If checked, the last counting order is inverted and hence the last example is addressed by index 1, the before last by index 2 and so on.", false, true));
        types.add(new ParameterTypeString(PARAMETER_VALUE, "The value which should be set.", false, false));
        return types;
    }

    @Override
    public boolean writesIntoExistingData() {
        return true;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), SetData.class, null);
    }
}

