/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.preprocessing.filter.AbstractFilteredDataProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.tools.Ontology;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import com.rapidminer.tools.math.container.Range;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Real2Integer
extends AbstractFilteredDataProcessing {
    public static final String PARAMETER_ROUND = "round_values";

    public Real2Integer(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSetMetaData applyOnFilteredMetaData(ExampleSetMetaData emd) {
        boolean round = this.getParameterAsBoolean(PARAMETER_ROUND);
        for (AttributeMetaData amd : emd.getAllAttributes()) {
            if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(amd.getValueType(), 2) && !Ontology.ATTRIBUTE_VALUE_TYPE.isA(amd.getValueType(), 3)) {
                amd.setType(3);
            }
            if (round) {
                amd.setValueRange(new Range(Math.round(amd.getValueRange().getLower()), Math.round(amd.getValueRange().getUpper())), SetRelation.EQUAL);
                continue;
            }
            amd.setValueRange(new Range((long)amd.getValueRange().getLower(), (long)amd.getValueRange().getUpper()), SetRelation.EQUAL);
        }
        return emd;
    }

    @Override
    public ExampleSet applyOnFiltered(ExampleSet exampleSet) throws OperatorException {
        boolean round = this.getParameterAsBoolean(PARAMETER_ROUND);
        LinkedList<Attribute> newAttributes = new LinkedList<Attribute>();
        Iterator<Attribute> a = exampleSet.getAttributes().iterator();
        while (a.hasNext()) {
            Attribute attribute = a.next();
            if (!Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), 2) || Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), 3)) continue;
            Attribute newAttribute = AttributeFactory.createAttribute(attribute.getName(), 3);
            newAttributes.add(newAttribute);
            exampleSet.getExampleTable().addAttribute(newAttribute);
            for (Example example : exampleSet) {
                double originalValue = example.getValue(attribute);
                long newValue = round ? Math.round(originalValue) : (long)originalValue;
                example.setValue(newAttribute, newValue);
            }
            a.remove();
        }
        for (Attribute attribute : newAttributes) {
            exampleSet.getAttributes().addRegular(attribute);
        }
        return exampleSet;
    }

    @Override
    protected int[] getFilterValueTypes() {
        return new int[]{4};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean(PARAMETER_ROUND, "Indicates if the values should be rounded instead of cutted.", false));
        return types;
    }

    @Override
    public boolean writesIntoExistingData() {
        return true;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), Real2Integer.class, null);
    }
}

