/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.SortedExampleSet;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.preprocessing.AbstractDataProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import com.rapidminer.tools.RandomGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PermutationOperator
extends AbstractDataProcessing {
    public PermutationOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        ArrayList<Integer> indicesCollection = new ArrayList<Integer>(exampleSet.size());
        for (int i = 0; i < exampleSet.size(); ++i) {
            indicesCollection.add(i);
        }
        Collections.shuffle(indicesCollection, RandomGenerator.getRandomGenerator(this));
        int[] indices = new int[exampleSet.size()];
        for (int i = 0; i < exampleSet.size(); ++i) {
            indices[i] = (Integer)indicesCollection.get(i);
        }
        return new SortedExampleSet(exampleSet, indices);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.addAll(RandomGenerator.getRandomGeneratorParameters(this));
        return types;
    }

    @Override
    public boolean writesIntoExistingData() {
        return false;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), PermutationOperator.class, null);
    }
}

