/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.preprocessing.filter.AbstractFilteredDataProcessing;
import com.rapidminer.tools.Ontology;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;

public class Numerical2Real
extends AbstractFilteredDataProcessing {
    public Numerical2Real(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSetMetaData applyOnFilteredMetaData(ExampleSetMetaData emd) {
        for (AttributeMetaData amd : emd.getAllAttributes()) {
            if (amd.isSpecial() || !Ontology.ATTRIBUTE_VALUE_TYPE.isA(amd.getValueType(), 2) || Ontology.ATTRIBUTE_VALUE_TYPE.isA(amd.getValueType(), 4)) continue;
            amd.setType(4);
        }
        return emd;
    }

    @Override
    public ExampleSet applyOnFiltered(ExampleSet exampleSet) throws OperatorException {
        for (Attribute attribute : exampleSet.getAttributes()) {
            if (!Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), 2) || Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), 4)) continue;
            Attribute newAttribute = AttributeFactory.changeValueType(attribute, 4);
            exampleSet.getAttributes().replace(attribute, newAttribute);
        }
        return exampleSet;
    }

    @Override
    protected int[] getFilterValueTypes() {
        return new int[]{2};
    }

    @Override
    public boolean writesIntoExistingData() {
        return false;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), Numerical2Real.class, null);
    }
}

