/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.AttributeSetPrecondition;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.preprocessing.filter.AbstractDateDataProcessing;
import com.rapidminer.operator.preprocessing.filter.Date2Numerical;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import java.util.List;

public class Numerical2Date
extends AbstractDateDataProcessing {
    public static final String PARAMETER_ATTRIBUTE_NAME = "attribute_name";
    public static final String PARAMETER_KEEP_OLD_ATTRIBUTE = "keep_old_attribute";
    public static final String PARMETER_TIME_OFFSET = "time_offset";

    public Numerical2Date(OperatorDescription description) {
        super(description);
        this.getExampleSetInputPort().addPrecondition(new AttributeSetPrecondition(this.getExampleSetInputPort(), AttributeSetPrecondition.getAttributesByParameter(this, PARAMETER_ATTRIBUTE_NAME), new String[0]));
    }

    @Override
    protected MetaData modifyMetaData(ExampleSetMetaData metaData) throws UndefinedParameterError {
        AttributeMetaData amd = metaData.getAttributeByName(this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME));
        if (amd != null) {
            AttributeMetaData newAttribute = amd.clone();
            newAttribute.setType(9);
            newAttribute.getMean().setUnkown();
            newAttribute.setValueSetRelation(SetRelation.UNKNOWN);
            if (!this.getParameterAsBoolean(PARAMETER_KEEP_OLD_ATTRIBUTE)) {
                metaData.removeAttribute(amd);
            } else {
                newAttribute.setName(newAttribute.getName() + "_AS_DATE");
            }
            metaData.addAttribute(newAttribute);
        }
        return metaData;
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        String attributeName = this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME);
        Long offset = this.getParameterAsInt(PARMETER_TIME_OFFSET);
        Attribute numericalAttribute = exampleSet.getAttributes().get(attributeName);
        if (numericalAttribute == null) {
            throw new UserError((Operator)this, 111, attributeName);
        }
        Attribute newAttribute = AttributeFactory.createAttribute(9);
        exampleSet.getExampleTable().addAttribute(newAttribute);
        exampleSet.getAttributes().addRegular(newAttribute);
        for (Example example : exampleSet) {
            double value = example.getValue(numericalAttribute);
            if (Double.isNaN(value)) {
                example.setValue(newAttribute, value);
                continue;
            }
            example.setValue(newAttribute, value += (double)offset.longValue());
        }
        if (!this.getParameterAsBoolean(PARAMETER_KEEP_OLD_ATTRIBUTE)) {
            exampleSet.getAttributes().remove(numericalAttribute);
            newAttribute.setName(attributeName);
        } else {
            newAttribute.setName(attributeName + "_AS_DATE");
        }
        return exampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeAttribute(PARAMETER_ATTRIBUTE_NAME, "The attribute which should be transformed.", this.getExampleSetInputPort(), false, false, 9));
        types.add(new ParameterTypeBoolean(PARAMETER_KEEP_OLD_ATTRIBUTE, "Indicates if the original numerical attribute should be kept.", false));
        types.add(new ParameterTypeInt(PARMETER_TIME_OFFSET, "Time offset in milliseconds", Integer.MIN_VALUE, Integer.MAX_VALUE, 0, true));
        return types;
    }

    @Override
    public boolean writesIntoExistingData() {
        return false;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), Date2Numerical.class, null);
    }
}

