/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.preprocessing.filter.NumericToNominal;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import com.rapidminer.tools.Tools;

public class NumericToPolynominal
extends NumericToNominal {
    public NumericToPolynominal(OperatorDescription description) {
        super(description);
    }

    @Override
    protected void setValue(Example example, Attribute newAttribute, double value) {
        if (Double.isNaN(value)) {
            example.setValue(newAttribute, Double.NaN);
        } else {
            example.setValue(newAttribute, newAttribute.getMapping().mapString(Tools.formatIntegerIfPossible(value, -1)));
        }
    }

    @Override
    protected int getGeneratedAttributevalueType() {
        return 1;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), NumericToPolynominal.class, null);
    }
}

