/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.preprocessing.filter.AbstractFilteredDataProcessing;
import com.rapidminer.parameter.UndefinedParameterError;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class NumericToNominal
extends AbstractFilteredDataProcessing {
    public NumericToNominal(OperatorDescription description) {
        super(description);
    }

    protected abstract void setValue(Example var1, Attribute var2, double var3) throws OperatorException;

    protected abstract int getGeneratedAttributevalueType();

    protected Attribute makeAttribute() {
        return AttributeFactory.createAttribute(this.getGeneratedAttributevalueType());
    }

    public void init() throws OperatorException {
    }

    public void cleanUp() throws OperatorException {
    }

    @Override
    public ExampleSetMetaData applyOnFilteredMetaData(ExampleSetMetaData emd) throws UndefinedParameterError {
        for (AttributeMetaData amd : emd.getAllAttributes()) {
            if (amd.isSpecial() || !amd.isNumerical()) continue;
            amd.setType(1);
            amd.setValueSetRelation(SetRelation.SUPERSET);
        }
        return emd;
    }

    @Override
    public ExampleSet applyOnFiltered(ExampleSet exampleSet) throws OperatorException {
        Attribute newAttribute;
        LinkedHashMap<Attribute, Attribute> translationMap = new LinkedHashMap<Attribute, Attribute>();
        for (Attribute attribute : exampleSet.getAttributes()) {
            if (!attribute.isNumerical()) continue;
            newAttribute = this.makeAttribute();
            translationMap.put(attribute, newAttribute);
        }
        for (Map.Entry entry : translationMap.entrySet()) {
            newAttribute = (Attribute)entry.getValue();
            exampleSet.getExampleTable().addAttribute(newAttribute);
            exampleSet.getAttributes().addRegular(newAttribute);
        }
        this.init();
        for (Example example : exampleSet) {
            for (Map.Entry replacement : translationMap.entrySet()) {
                Attribute oldAttribute = (Attribute)replacement.getKey();
                Attribute newAttribute2 = (Attribute)replacement.getValue();
                double oldValue = example.getValue(oldAttribute);
                this.setValue(example, newAttribute2, oldValue);
            }
            this.checkForStop();
        }
        this.cleanUp();
        for (Map.Entry entry : translationMap.entrySet()) {
            Attribute originalAttribute = (Attribute)entry.getKey();
            exampleSet.getAttributes().remove(originalAttribute);
            ((Attribute)entry.getValue()).setName(originalAttribute.getName());
        }
        return exampleSet;
    }

    @Override
    public boolean writesIntoExistingData() {
        return false;
    }

    @Override
    protected int[] getFilterValueTypes() {
        return new int[]{2};
    }
}

