/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.preprocessing.filter.NumericToNominal;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import com.rapidminer.tools.math.container.Range;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;

public class NumericToBinominal
extends NumericToNominal {
    public static final String PARAMETER_MIN = "min";
    public static final String PARAMETER_MAX = "max";

    public NumericToBinominal(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSetMetaData applyOnFilteredMetaData(ExampleSetMetaData emd) throws UndefinedParameterError {
        double min = this.getParameterAsDouble(PARAMETER_MIN);
        double max = this.getParameterAsDouble(PARAMETER_MAX);
        for (AttributeMetaData amd : emd.getAllAttributes()) {
            if (!amd.isNumerical()) continue;
            Range valueRange = amd.getValueRange();
            amd.setType(6);
            if (amd.getValueSetRelation() != SetRelation.SUPERSET && valueRange.getUpper() < min || valueRange.getLower() > max) {
                amd.setValueSet(Collections.singleton("true"), SetRelation.EQUAL);
                continue;
            }
            if (amd.getValueSetRelation() != SetRelation.SUPERSET && valueRange.getLower() > min && valueRange.getUpper() < max) {
                amd.setValueSet(Collections.singleton("false"), SetRelation.EQUAL);
                continue;
            }
            TreeSet<String> values = new TreeSet<String>();
            values.add("false");
            values.add("true");
            amd.setValueSet(values, SetRelation.SUBSET);
        }
        return emd;
    }

    @Override
    protected void setValue(Example example, Attribute newAttribute, double value) throws OperatorException {
        double min = this.getParameterAsDouble(PARAMETER_MIN);
        double max = this.getParameterAsDouble(PARAMETER_MAX);
        if (Double.isNaN(value)) {
            example.setValue(newAttribute, Double.NaN);
        } else if (value < min || value > max) {
            example.setValue(newAttribute, newAttribute.getMapping().mapString("true"));
        } else {
            example.setValue(newAttribute, newAttribute.getMapping().mapString("false"));
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeDouble(PARAMETER_MIN, "The minimal value which is mapped to false (included).", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, false));
        types.add(new ParameterTypeDouble(PARAMETER_MAX, "The maximal value which is mapped to false (included).", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, false));
        return types;
    }

    @Override
    protected int getGeneratedAttributevalueType() {
        return 6;
    }

    @Override
    protected Attribute makeAttribute() {
        Attribute att = AttributeFactory.createAttribute(this.getGeneratedAttributevalueType());
        att.getMapping().mapString("false");
        att.getMapping().mapString("true");
        return att;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), NumericToBinominal.class, null);
    }
}

