/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.SortedExampleSet;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.preprocessing.AbstractDataProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttributes;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;

public class NonDominatedSorting
extends AbstractDataProcessing {
    public static final String PARAMETER_ATTRIBUTES = "attributes";

    public NonDominatedSorting(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        String attributesString = this.getParameterAsString(PARAMETER_ATTRIBUTES);
        Pattern pattern = Pattern.compile(attributesString);
        LinkedList<Attribute> attributeList = new LinkedList<Attribute>();
        for (Attribute attribute : exampleSet.getAttributes()) {
            if (!attribute.isNumerical() || !pattern.matcher(attribute.getName()).matches()) continue;
            attributeList.add(attribute);
        }
        Attribute[] attributes = new Attribute[attributeList.size()];
        attributeList.toArray(attributes);
        LinkedList<SortingObject> sortingObjects = new LinkedList<SortingObject>();
        int index = 0;
        for (Example example : exampleSet) {
            double[] dArray = new double[attributes.length];
            int a = 0;
            for (Attribute attribute : attributes) {
                dArray[a] = example.getValue(attribute);
                ++a;
            }
            sortingObjects.add(new SortingObject(index, dArray));
            ++index;
        }
        ArrayList<List<SortingObject>> ranks = new ArrayList<List<SortingObject>>();
        while (sortingObjects.size() > 0) {
            List<SortingObject> rank = this.getNextRank(sortingObjects);
            ranks.add(rank);
            Iterator<SortingObject> iterator = rank.iterator();
            while (iterator.hasNext()) {
                sortingObjects.remove(iterator.next());
            }
        }
        sortingObjects.clear();
        for (List list : ranks) {
            sortingObjects.addAll(list);
        }
        int[] mapping = new int[sortingObjects.size()];
        index = 0;
        for (SortingObject sortingObject : sortingObjects) {
            mapping[index] = sortingObject.originalIndex;
            ++index;
        }
        SortedExampleSet sortedExampleSet = new SortedExampleSet(exampleSet, mapping);
        return sortedExampleSet;
    }

    private List<SortingObject> getNextRank(List<SortingObject> population) {
        ArrayList<SortingObject> rank = new ArrayList<SortingObject>();
        for (int i = 0; i < population.size(); ++i) {
            SortingObject current = population.get(i);
            rank.add(current);
            boolean delete = false;
            for (int j = rank.size() - 2; j >= 0; --j) {
                SortingObject ranked = (SortingObject)rank.get(j);
                if (NonDominatedSorting.isDominated(ranked, current)) {
                    rank.remove(ranked);
                }
                if (!NonDominatedSorting.isDominated(current, ranked)) continue;
                delete = true;
            }
            if (!delete) continue;
            rank.remove(current);
        }
        return rank;
    }

    private static boolean isDominated(SortingObject i1, SortingObject i2) {
        double[] pv1 = i1.values;
        double[] pv2 = i2.values;
        double[][] performances = new double[pv1.length][2];
        for (int p = 0; p < performances.length; ++p) {
            performances[p][0] = pv1[p];
            performances[p][1] = pv2[p];
        }
        boolean dominated = true;
        for (int p = 0; p < performances.length; ++p) {
            dominated &= performances[p][1] >= performances[p][0];
        }
        boolean oneActuallyBetter = false;
        for (int p = 0; p < performances.length; ++p) {
            oneActuallyBetter |= performances[p][1] > performances[p][0];
        }
        return dominated &= oneActuallyBetter;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeAttributes type = new ParameterTypeAttributes(PARAMETER_ATTRIBUTES, "Defines the attributes which should be used for the sorting.", this.getExampleSetInputPort(), false);
        type.setExpert(false);
        types.add(type);
        return types;
    }

    @Override
    public boolean writesIntoExistingData() {
        return false;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), NonDominatedSorting.class, null);
    }

    private static class SortingObject {
        private int originalIndex;
        private double[] values;

        public SortingObject(int originalIndex, double[] values) {
            this.originalIndex = originalIndex;
            this.values = values;
        }
    }
}

