/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.SimpleAttributes;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.ViewAttribute;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.preprocessing.PreprocessingModel;
import com.rapidminer.operator.preprocessing.PreprocessingOperator;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import com.rapidminer.tools.math.container.Range;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;

public class NominalToNumeric
extends PreprocessingOperator {
    public NominalToNumeric(OperatorDescription description) {
        super(description);
    }

    @Override
    protected Collection<AttributeMetaData> modifyAttributeMetaData(ExampleSetMetaData emd, AttributeMetaData amd) {
        int mappingSize = amd.getValueSet().size();
        amd.setType(2);
        amd.setValueRange(new Range(0.0, mappingSize - 1), amd.getValueSetRelation());
        return Collections.singleton(amd);
    }

    @Override
    public PreprocessingModel createPreprocessingModel(ExampleSet exampleSet) throws OperatorException {
        return new NominalToNumericModel(exampleSet);
    }

    @Override
    public Class<? extends PreprocessingModel> getPreprocessingModelClass() {
        return NominalToNumericModel.class;
    }

    @Override
    protected int[] getFilterValueTypes() {
        return new int[]{1, 1};
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), NominalToNumeric.class, this.attributeSelector);
    }

    private static class NominalToNumericModel
    extends PreprocessingModel {
        private static final long serialVersionUID = -4203775081616082145L;

        protected NominalToNumericModel(ExampleSet exampleSet) {
            super(exampleSet);
        }

        @Override
        public ExampleSet applyOnData(ExampleSet exampleSet) throws OperatorException {
            LinkedList<Attribute> nominalAttributes = new LinkedList<Attribute>();
            LinkedList<Attribute> transformedAttributes = new LinkedList<Attribute>();
            for (Attribute attribute : exampleSet.getAttributes()) {
                if (attribute.isNumerical()) continue;
                nominalAttributes.add(attribute);
                transformedAttributes.add(AttributeFactory.createAttribute(attribute.getName(), 2));
            }
            exampleSet.getExampleTable().addAttributes(transformedAttributes);
            for (Example example : exampleSet) {
                Iterator target = transformedAttributes.iterator();
                for (Attribute attribute : nominalAttributes) {
                    example.setValue((Attribute)target.next(), example.getValue(attribute));
                }
            }
            Attributes attributes = exampleSet.getAttributes();
            for (Attribute attribute : exampleSet.getAttributes()) {
                if (attribute.isNumerical()) continue;
                attributes.replace(attribute, transformedAttributes.poll());
            }
            return exampleSet;
        }

        @Override
        public Attributes getTargetAttributes(ExampleSet parentSet) {
            SimpleAttributes attributes = new SimpleAttributes();
            Iterator<AttributeRole> specialRoles = parentSet.getAttributes().specialAttributes();
            while (specialRoles.hasNext()) {
                attributes.add(specialRoles.next());
            }
            Iterator<AttributeRole> i = parentSet.getAttributes().allAttributeRoles();
            while (i.hasNext()) {
                AttributeRole attributeRole = i.next();
                if (attributeRole.isSpecial()) continue;
                Attribute attribute = attributeRole.getAttribute();
                if (!attribute.isNumerical()) {
                    attributes.addRegular(new ViewAttribute(this, attribute, attribute.getName(), 3, null));
                    continue;
                }
                attributes.add(attributeRole);
            }
            return attributes;
        }

        @Override
        public double getValue(Attribute targetAttribute, double value) {
            return value;
        }

        @Override
        public String getName() {
            return "Nominal2Numerical Model";
        }
    }
}

