/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.SimpleAttributes;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.BinominalMapping;
import com.rapidminer.example.table.ViewAttribute;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.preprocessing.PreprocessingModel;
import com.rapidminer.tools.Tools;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class NominalToBinominalModel
extends PreprocessingModel {
    private static final long serialVersionUID = 2882937201039541604L;
    private final Set<String> dichotomizationAttributeNames;
    private final Set<String> changeTypeAttributeNames;
    private Map<Attribute, Double> binominalAttributeValueMap = new LinkedHashMap<Attribute, Double>();
    private boolean useOnlyUnderscoreInNames = false;

    public NominalToBinominalModel(ExampleSet exampleSet, boolean translateBinominals, boolean useOnlyUnderscoreInNames) {
        super(exampleSet);
        this.useOnlyUnderscoreInNames = useOnlyUnderscoreInNames;
        this.dichotomizationAttributeNames = new HashSet<String>();
        this.changeTypeAttributeNames = new HashSet<String>();
        for (Attribute attribute : exampleSet.getAttributes()) {
            if (!attribute.isNominal()) continue;
            if (attribute.getMapping().size() > 2 || translateBinominals) {
                this.dichotomizationAttributeNames.add(attribute.getName());
                continue;
            }
            this.changeTypeAttributeNames.add(attribute.getName());
        }
    }

    @Override
    public ExampleSet applyOnData(ExampleSet exampleSet) throws OperatorException {
        LinkedHashMap<Attribute, Attribute> dichotomizationMap = new LinkedHashMap<Attribute, Attribute>();
        LinkedHashMap<Attribute, Attribute> changeTypeMap = new LinkedHashMap<Attribute, Attribute>();
        Attributes attributes = exampleSet.getAttributes();
        Iterator<Attribute> iterator = attributes.allAttributes();
        while (iterator.hasNext()) {
            Attribute sourceAttribute = iterator.next();
            String sourceAttributeName = sourceAttribute.getName();
            if (this.dichotomizationAttributeNames.contains(sourceAttributeName)) {
                for (String string : this.getTrainingHeader().getAttributes().get(sourceAttributeName).getMapping().getValues()) {
                    Attribute newAttribute = AttributeFactory.createAttribute(this.createAttributeName(sourceAttributeName, string), 6);
                    BinominalMapping mapping = new BinominalMapping();
                    mapping.mapString("false");
                    mapping.mapString("true");
                    newAttribute.setMapping(mapping);
                    this.binominalAttributeValueMap.put(newAttribute, Double.valueOf(sourceAttribute.getMapping().mapString(string)));
                    dichotomizationMap.put(newAttribute, sourceAttribute);
                }
                continue;
            }
            if (!this.changeTypeAttributeNames.contains(sourceAttributeName)) continue;
            Attribute newAttribute = AttributeFactory.createAttribute(sourceAttributeName + "_binominal", 6);
            BinominalMapping binominalMapping = new BinominalMapping();
            binominalMapping.mapString(sourceAttribute.getMapping().getNegativeString());
            binominalMapping.mapString(sourceAttribute.getMapping().getPositiveString());
            newAttribute.setMapping(binominalMapping);
            changeTypeMap.put(newAttribute, sourceAttribute);
        }
        exampleSet.getExampleTable().addAttributes(dichotomizationMap.keySet());
        for (Attribute attribute : dichotomizationMap.keySet()) {
            attributes.addRegular(attribute);
        }
        exampleSet.getExampleTable().addAttributes(changeTypeMap.keySet());
        for (Attribute attribute : changeTypeMap.keySet()) {
            attributes.addRegular(attribute);
        }
        this.binominalAttributeValueMap = new LinkedHashMap<Attribute, Double>(this.binominalAttributeValueMap);
        for (Example example : exampleSet) {
            double sourceValue;
            for (Map.Entry entry : dichotomizationMap.entrySet()) {
                sourceValue = example.getValue((Attribute)entry.getValue());
                example.setValue((Attribute)entry.getKey(), this.getValue((Attribute)entry.getKey(), sourceValue));
            }
            for (Map.Entry entry : changeTypeMap.entrySet()) {
                sourceValue = example.getValue((Attribute)entry.getValue());
                example.setValue((Attribute)entry.getKey(), sourceValue);
            }
        }
        Iterator<Attribute> attributeIterator = attributes.allAttributes();
        while (attributeIterator.hasNext()) {
            Attribute attribute;
            attribute = attributeIterator.next();
            if (!this.dichotomizationAttributeNames.contains(attribute.getName()) && !this.changeTypeAttributeNames.contains(attribute.getName())) continue;
            attributeIterator.remove();
        }
        for (Map.Entry entry : changeTypeMap.entrySet()) {
            String string = ((Attribute)entry.getValue()).getName();
            ((Attribute)entry.getKey()).setName(string);
        }
        return exampleSet;
    }

    @Override
    public Attributes getTargetAttributes(ExampleSet applySet) {
        Attributes attributes = this.getSpecialAttributes(applySet);
        for (Attribute attribute : applySet.getAttributes()) {
            if (this.dichotomizationAttributeNames.contains(attribute.getName())) {
                for (String value : attribute.getMapping().getValues()) {
                    attributes.addRegular(this.createBinominalValueAttribute(attribute, value));
                }
                continue;
            }
            attributes.addRegular(attribute);
        }
        return attributes;
    }

    @Override
    public double getValue(Attribute targetAttribute, double value) {
        if (Double.compare(value, this.binominalAttributeValueMap.get(targetAttribute)) == 0) {
            return 1.0;
        }
        return 0.0;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Mapping Model for attributes:");
        for (String attributeName : this.dichotomizationAttributeNames) {
            buffer.append(attributeName + Tools.getLineSeparator());
        }
        return buffer.toString();
    }

    private Attribute createBinominalValueAttribute(Attribute attribute, String value) {
        BinominalMapping mapping = new BinominalMapping();
        mapping.mapString("false");
        mapping.mapString("true");
        String newName = this.createAttributeName(attribute.getName(), value);
        ViewAttribute newAttribute = new ViewAttribute(this, attribute, newName, 6, mapping);
        this.binominalAttributeValueMap.put(newAttribute, Double.valueOf(attribute.getMapping().mapString(value)));
        return newAttribute;
    }

    private Attributes getSpecialAttributes(ExampleSet applySet) {
        SimpleAttributes attributes = new SimpleAttributes();
        Iterator<AttributeRole> roleIterator = applySet.getAttributes().allAttributeRoles();
        while (roleIterator.hasNext()) {
            AttributeRole role = roleIterator.next();
            if (!role.isSpecial()) continue;
            attributes.add(role);
        }
        return attributes;
    }

    private String createAttributeName(String base, String value) {
        if (this.useOnlyUnderscoreInNames) {
            return base + "_" + value;
        }
        return base + " = " + value;
    }
}

