/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.preprocessing.PreprocessingModel;
import com.rapidminer.operator.preprocessing.PreprocessingOperator;
import com.rapidminer.operator.preprocessing.filter.NominalToBinominalModel;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;

public class NominalToBinominal
extends PreprocessingOperator {
    public static final String PARAMETER_USE_UNDERSCORE_IN_NAME = "use_underscore_in_name";
    public static final String PARAMETER_TRANSFORM_BINOIMINAL = "transform_binominal";

    public NominalToBinominal(OperatorDescription description) {
        super(description);
    }

    @Override
    protected Collection<AttributeMetaData> modifyAttributeMetaData(ExampleSetMetaData emd, AttributeMetaData amd) {
        boolean transformBinominal = this.getParameterAsBoolean(PARAMETER_TRANSFORM_BINOIMINAL);
        if (amd.isNominal()) {
            LinkedList<AttributeMetaData> newAttributeMetaDataCollection = new LinkedList<AttributeMetaData>();
            if (!transformBinominal && amd.getValueSet().size() == 2) {
                amd.setType(6);
                return Collections.singletonList(amd);
            }
            if (amd.getValueSetRelation() != SetRelation.UNKNOWN) {
                for (String value : amd.getValueSet()) {
                    String name = amd.getName() + (this.getParameterAsBoolean(PARAMETER_USE_UNDERSCORE_IN_NAME) ? "_" : " = ") + value;
                    AttributeMetaData newAttributeMetaData = new AttributeMetaData(name, 6);
                    TreeSet<String> values = new TreeSet<String>();
                    values.add("false");
                    values.add("true");
                    newAttributeMetaData.setValueSet(values, SetRelation.EQUAL);
                    newAttributeMetaDataCollection.add(newAttributeMetaData);
                    emd.mergeSetRelation(amd.getValueSetRelation());
                }
            }
            return newAttributeMetaDataCollection;
        }
        return null;
    }

    @Override
    public PreprocessingModel createPreprocessingModel(ExampleSet exampleSet) throws OperatorException {
        NominalToBinominalModel model = new NominalToBinominalModel(exampleSet, this.getParameterAsBoolean(PARAMETER_TRANSFORM_BINOIMINAL), this.getParameterAsBoolean(PARAMETER_USE_UNDERSCORE_IN_NAME));
        return model;
    }

    @Override
    public Class<? extends PreprocessingModel> getPreprocessingModelClass() {
        return NominalToBinominalModel.class;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean(PARAMETER_TRANSFORM_BINOIMINAL, "Indicates if attributes which are already binominal should be dichotomized.", false, false));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_UNDERSCORE_IN_NAME, "Indicates if underscores should be used in the new attribute names instead of empty spaces and '='. Although the resulting names are harder to read for humans it might be more appropriate to use these if the data should be written into a database system.", false));
        return types;
    }

    @Override
    protected int[] getFilterValueTypes() {
        return new int[]{1};
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), NominalToBinominal.class, this.attributeSelector);
    }
}

