/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.preprocessing.filter.AbstractFilteredDataProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import com.rapidminer.tools.StrictDecimalFormat;
import com.rapidminer.tools.math.container.Range;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class NominalNumbers2Numerical
extends AbstractFilteredDataProcessing {
    public static final String PARAMETER_DECIMAL_POINT_CHARACTER = "decimal_point_character";
    public static final String PARAMETER_GROUP_SEPARATOR = "group_separator";

    public NominalNumbers2Numerical(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSetMetaData applyOnFilteredMetaData(ExampleSetMetaData emd) throws UndefinedParameterError {
        NumberFormat format = this.makeFormat();
        Iterator<AttributeMetaData> iterator = emd.getAllAttributes().iterator();
        LinkedList<AttributeMetaData> affectedList = new LinkedList<AttributeMetaData>();
        while (iterator.hasNext()) {
            AttributeMetaData amd = iterator.next();
            if (!amd.isNominal()) continue;
            Set<String> values = amd.getValueSet();
            boolean isTransformed = true;
            double min = Double.POSITIVE_INFINITY;
            double max = Double.NEGATIVE_INFINITY;
            try {
                for (String value : values) {
                    double numValue = format.parse(value).doubleValue();
                    min = Math.min(min, numValue);
                    max = Math.max(max, numValue);
                }
            }
            catch (ParseException e) {
                isTransformed = false;
            }
            if (!isTransformed) continue;
            iterator.remove();
            affectedList.add(amd);
            amd.setType(2);
            if (min == Double.POSITIVE_INFINITY) {
                min = Double.NEGATIVE_INFINITY;
            }
            if (max == Double.NEGATIVE_INFINITY) {
                max = Double.POSITIVE_INFINITY;
            }
            amd.setValueRange(new Range(min, max), SetRelation.EQUAL);
        }
        emd.addAllAttributes(affectedList);
        return emd;
    }

    @Override
    public ExampleSet applyOnFiltered(ExampleSet exampleSet) throws OperatorException {
        NumberFormat format = this.makeFormat();
        LinkedList<Attribute> newAttributes = new LinkedList<Attribute>();
        Iterator<Attribute> a = exampleSet.getAttributes().iterator();
        while (a.hasNext()) {
            Attribute attribute = a.next();
            if (!attribute.isNominal()) continue;
            boolean isNumericalNominal = true;
            try {
                for (String value : attribute.getMapping().getValues()) {
                    format.parse(value);
                }
            }
            catch (Exception e) {
                isNumericalNominal = false;
            }
            if (!isNumericalNominal) continue;
            Attribute newAttribute = AttributeFactory.createAttribute(2);
            exampleSet.getExampleTable().addAttribute(newAttribute);
            newAttributes.add(newAttribute);
            for (Example e : exampleSet) {
                double oldValue = e.getValue(attribute);
                if (!Double.isNaN(oldValue)) {
                    String value = e.getValueAsString(attribute);
                    try {
                        e.setValue(newAttribute, format.parse(value).doubleValue());
                        continue;
                    }
                    catch (ParseException ex) {
                        throw new UserError((Operator)this, (Throwable)ex, 946, value);
                    }
                }
                e.setValue(newAttribute, Double.NaN);
            }
            a.remove();
            newAttribute.setName(attribute.getName());
        }
        for (Attribute attribute : newAttributes) {
            exampleSet.getAttributes().addRegular(attribute);
        }
        return exampleSet;
    }

    private NumberFormat makeFormat() throws UndefinedParameterError {
        StrictDecimalFormat format = StrictDecimalFormat.getInstance(this);
        return format;
    }

    @Override
    protected int[] getFilterValueTypes() {
        return new int[]{1};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.addAll(StrictDecimalFormat.getParameterTypes(this));
        return types;
    }

    @Override
    public boolean writesIntoExistingData() {
        return false;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), NominalNumbers2Numerical.class, null);
    }
}

