/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.preprocessing.filter.AbstractFilteredDataProcessing;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;

public class Nominal2String
extends AbstractFilteredDataProcessing {
    public Nominal2String(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet applyOnFiltered(ExampleSet exampleSet) throws OperatorException {
        for (Attribute attribute : exampleSet.getAttributes()) {
            if (!attribute.isNominal()) continue;
            Attribute newAttribute = AttributeFactory.changeValueType(attribute, 5);
            exampleSet.getAttributes().replace(attribute, newAttribute);
        }
        return exampleSet;
    }

    @Override
    public ExampleSetMetaData applyOnFilteredMetaData(ExampleSetMetaData emd) {
        for (AttributeMetaData amd : emd.getAllAttributes()) {
            if (!amd.isNominal()) continue;
            amd.setType(5);
        }
        return emd;
    }

    @Override
    protected int[] getFilterValueTypes() {
        return new int[]{1};
    }

    @Override
    public boolean writesIntoExistingData() {
        return false;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), Nominal2String.class, null);
    }
}

