/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.SimpleProcessSetupError;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.AttributeSetPrecondition;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.ports.metadata.SimpleMetaDataError;
import com.rapidminer.operator.preprocessing.filter.AbstractDateDataProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDateFormat;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.math.container.Range;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class Nominal2Date
extends AbstractDateDataProcessing {
    private static final String ATTRIBUTE_NAME_POSTFIX = "_old";
    public static final String PARAMETER_ATTRIBUTE_NAME = "attribute_name";
    public static final String PARAMETER_DATE_TYPE = "date_type";
    public static final String PARAMETER_DATE_FORMAT = "date_format";
    public static final String PARAMETER_TIME_ZONE = "time_zone";
    public static final String PARAMETER_LOCALE = "locale";
    public static final String PARAMETER_KEEP_OLD_ATTRIBUTE = "keep_old_attribute";
    public static final String[] VALUE_TYPES = new String[]{"date", "time", "date_time"};
    public static final int DATE = 0;
    public static final int TIME = 1;
    public static final int DATE_TIME = 2;

    public Nominal2Date(OperatorDescription description) {
        super(description);
        this.getExampleSetInputPort().addPrecondition(new AttributeSetPrecondition(this.getExampleSetInputPort(), AttributeSetPrecondition.getAttributesByParameter(this, PARAMETER_ATTRIBUTE_NAME), new String[0]));
    }

    @Override
    protected MetaData modifyMetaData(ExampleSetMetaData metaData) throws UndefinedParameterError {
        SimpleDateFormat format = null;
        try {
            String dateFormat = this.getParameterAsString(PARAMETER_DATE_FORMAT);
            int localeIndex = this.getParameterAsInt(PARAMETER_LOCALE);
            Locale selectedLocale = Locale.US;
            if (localeIndex >= 0 && localeIndex < availableLocales.size()) {
                selectedLocale = (Locale)availableLocales.get(this.getParameterAsInt(PARAMETER_LOCALE));
            }
            format = new SimpleDateFormat(dateFormat, selectedLocale);
        }
        catch (IllegalArgumentException e) {
            this.addError(new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, this.getPortOwner(), "parameter_invalid_time_format", PARAMETER_DATE_FORMAT));
        }
        AttributeMetaData amd = metaData.getAttributeByName(this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME));
        if (amd != null) {
            AttributeMetaData newAttribute = amd.clone();
            int dateType = this.getParameterAsInt(PARAMETER_DATE_TYPE);
            int valueType = 9;
            if (dateType == 1) {
                valueType = 11;
            } else if (dateType == 0) {
                valueType = 10;
            }
            newAttribute.setType(valueType);
            newAttribute.getMean().setUnkown();
            if (format == null) {
                newAttribute.setValueSetRelation(SetRelation.UNKNOWN);
            } else if (amd.getValueSet() != null) {
                try {
                    long min = Long.MAX_VALUE;
                    long max = Long.MIN_VALUE;
                    for (String value : amd.getValueSet()) {
                        Date date = format.parse(value);
                        long millis = date.getTime();
                        if (millis < min) {
                            min = millis;
                        }
                        if (millis <= max) continue;
                        max = millis;
                    }
                    newAttribute.setValueRange(new Range(min, max), amd.getValueSetRelation());
                }
                catch (ParseException e) {
                    this.getExampleSetInputPort().addError(new SimpleMetaDataError(ProcessSetupError.Severity.WARNING, (Port)this.getExampleSetInputPort(), "cannot_parse_date", e.getLocalizedMessage()));
                    newAttribute.setValueSetRelation(SetRelation.UNKNOWN);
                }
            } else {
                newAttribute.setValueSetRelation(SetRelation.UNKNOWN);
            }
            if (!this.getParameterAsBoolean(PARAMETER_KEEP_OLD_ATTRIBUTE)) {
                metaData.removeAttribute(amd);
            } else {
                amd.setName(amd.getName() + ATTRIBUTE_NAME_POSTFIX);
            }
            metaData.addAttribute(newAttribute);
        }
        return metaData;
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        String attributeName = this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME);
        Attribute oldAttribute = exampleSet.getAttributes().get(attributeName);
        if (oldAttribute == null) {
            throw new UserError((Operator)this, 111, attributeName);
        }
        String dateFormat = this.getParameterAsString(PARAMETER_DATE_FORMAT);
        int dateType = this.getParameterAsInt(PARAMETER_DATE_TYPE);
        int localeIndex = this.getParameterAsInt(PARAMETER_LOCALE);
        Locale selectedLocale = Locale.US;
        if (localeIndex >= 0 && localeIndex < availableLocales.size()) {
            selectedLocale = (Locale)availableLocales.get(this.getParameterAsInt(PARAMETER_LOCALE));
        }
        int valueType = 9;
        if (dateType == 1) {
            valueType = 11;
        } else if (dateType == 0) {
            valueType = 10;
        }
        Attribute newAttribute = AttributeFactory.createAttribute(valueType);
        exampleSet.getExampleTable().addAttribute(newAttribute);
        exampleSet.getAttributes().addRegular(newAttribute);
        SimpleDateFormat parser = new SimpleDateFormat(dateFormat, selectedLocale);
        parser.setTimeZone(Tools.getTimeZone(this.getParameterAsInt(PARAMETER_TIME_ZONE)));
        int row = 1;
        for (Example e : exampleSet) {
            if (Double.isNaN(e.getValue(oldAttribute))) {
                e.setValue(newAttribute, Double.NaN);
            } else {
                String oldValue = e.getValueAsString(oldAttribute);
                Date date = null;
                try {
                    date = parser.parse(oldValue);
                }
                catch (ParseException e1) {
                    throw new UserError((Operator)this, 931, dateFormat, oldAttribute.getName(), row, e1.getMessage());
                }
                if (dateType == 1) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(date);
                    calendar.set(1970, 1, 1);
                    e.setValue(newAttribute, calendar.getTimeInMillis());
                } else {
                    e.setValue(newAttribute, date.getTime());
                }
            }
            ++row;
        }
        if (!this.getParameterAsBoolean(PARAMETER_KEEP_OLD_ATTRIBUTE)) {
            exampleSet.getAttributes().remove(oldAttribute);
        } else {
            oldAttribute.setName(attributeName + ATTRIBUTE_NAME_POSTFIX);
        }
        newAttribute.setName(attributeName);
        return exampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeAttribute attributeParamType = new ParameterTypeAttribute(PARAMETER_ATTRIBUTE_NAME, "The attribute which should be parsed.", this.getExampleSetInputPort(), false, false, 1);
        types.add(attributeParamType);
        ParameterTypeSingle type = new ParameterTypeCategory(PARAMETER_DATE_TYPE, "The desired value type for the parsed attribute.", VALUE_TYPES, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDateFormat(attributeParamType, PARAMETER_DATE_FORMAT, "The parse format of the date values, for example \"yyyy/MM/dd\".", this.getExampleSetInputPort(), false);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_TIME_ZONE, "The time zone used for the date objects if not specified in the date string itself.", Tools.getAllTimeZones(), Tools.getPreferredTimeZoneIndex());
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_LOCALE, "The used locale for date texts, for example \"Wed\" (English) in contrast to \"Mi\" (German).", availableLocaleNames, defaultLocale);
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_KEEP_OLD_ATTRIBUTE, "Indicates if the original date attribute should be kept.", false));
        return types;
    }

    @Override
    public boolean writesIntoExistingData() {
        return false;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), Nominal2Date.class, null);
    }
}

