/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MDInteger;
import com.rapidminer.operator.preprocessing.filter.ValueReplenishment;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.ParameterCondition;
import com.rapidminer.tools.Ontology;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class MissingValueReplenishment
extends ValueReplenishment {
    public static final String PARAMETER_REPLENISHMENT_VALUE = "replenishment_value";
    private static final int NONE = 0;
    private static final int MINIMUM = 1;
    private static final int MAXIMUM = 2;
    private static final int AVERAGE = 3;
    private static final int ZERO = 4;
    private static final int VALUE = 5;
    private static final String[] REPLENISHMENT_NAMES = new String[]{"none", "minimum", "maximum", "average", "zero", "value"};

    public MissingValueReplenishment(OperatorDescription description) {
        super(description);
    }

    @Override
    protected Collection<AttributeMetaData> modifyAttributeMetaData(ExampleSetMetaData emd, AttributeMetaData amd) throws UndefinedParameterError {
        amd.setNumberOfMissingValues(new MDInteger(0));
        return Collections.singletonList(amd);
    }

    @Override
    protected int[] getFilterValueTypes() {
        return new int[]{0};
    }

    @Override
    public String[] getFunctionNames() {
        return REPLENISHMENT_NAMES;
    }

    @Override
    public int getDefaultFunction() {
        return 3;
    }

    @Override
    public int getDefaultColumnFunction() {
        return 3;
    }

    @Override
    public double getReplacedValue() {
        return Double.NaN;
    }

    @Override
    public double getReplenishmentValue(int functionIndex, ExampleSet exampleSet, Attribute attribute) throws UserError {
        switch (functionIndex) {
            case 0: {
                return Double.NaN;
            }
            case 1: {
                return exampleSet.getStatistics(attribute, "minimum");
            }
            case 2: {
                return exampleSet.getStatistics(attribute, "maximum");
            }
            case 3: {
                if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), 9)) {
                    return Double.NaN;
                }
                if (attribute.isNominal()) {
                    return exampleSet.getStatistics(attribute, "mode");
                }
                return exampleSet.getStatistics(attribute, "average");
            }
            case 4: {
                return 0.0;
            }
            case 5: {
                String valueString = this.getParameterAsString(PARAMETER_REPLENISHMENT_VALUE);
                if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), 9)) {
                    String formatString = null;
                    if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), 10)) {
                        formatString = "MM/dd/yyyy";
                    } else if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), 11)) {
                        formatString = "hh.mm a";
                    } else if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), 9)) {
                        formatString = "MM/dd/yyyy hh.mm a";
                    }
                    SimpleDateFormat dateFormat = new SimpleDateFormat(formatString, Locale.US);
                    try {
                        Date date = dateFormat.parse(valueString);
                        return date.getTime();
                    }
                    catch (ParseException e) {
                        throw new UserError((Operator)this, 218, PARAMETER_REPLENISHMENT_VALUE, valueString);
                    }
                }
                if (attribute.isNominal()) {
                    return attribute.getMapping().mapString(valueString);
                }
                try {
                    return Double.parseDouble(valueString);
                }
                catch (NumberFormatException e) {
                    throw new UserError((Operator)this, 211, PARAMETER_REPLENISHMENT_VALUE, valueString);
                }
            }
        }
        throw new RuntimeException("Illegal value functionIndex: " + functionIndex);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeString type = new ParameterTypeString(PARAMETER_REPLENISHMENT_VALUE, "This value is used for some of the replenishment types.", true, false);
        type.registerDependencyCondition(new ParameterCondition(this, "default", true){

            @Override
            public boolean isConditionFullfilled() {
                try {
                    if (MissingValueReplenishment.this.getParameterAsInt("default") == 5) {
                        return true;
                    }
                    List<String[]> pairs = MissingValueReplenishment.this.getParameterList("columns");
                    if (pairs != null) {
                        for (String[] pair : pairs) {
                            if (!pair[1].equals("value") && !pair[1].equals("5")) continue;
                            return true;
                        }
                    }
                }
                catch (UndefinedParameterError undefinedParameterError) {
                    // empty catch block
                }
                return false;
            }
        });
        types.add(type);
        return types;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), MissingValueReplenishment.class, this.attributeSelector);
    }
}

