/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.Condition;
import com.rapidminer.example.set.ConditionCreationException;
import com.rapidminer.example.set.ConditionedExampleSet;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.features.weighting.InfoGainWeighting;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetPassThroughRule;
import com.rapidminer.operator.ports.metadata.MDInteger;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.ports.metadata.SubprocessTransformRule;
import com.rapidminer.operator.tools.AttributeSubsetSelector;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import com.rapidminer.tools.OperatorService;
import com.rapidminer.tools.RandomGenerator;
import java.util.Iterator;
import java.util.List;

public class MissingValueImputation
extends OperatorChain {
    public static final String PARAMETER_ORDER = "order";
    public static final String PARAMETER_SORT = "sort";
    public static final String PARAMETER_ITERATE = "iterate";
    public static final String PARAMETER_LEARN_ON_COMPLETE_CASES = "learn_on_complete_cases";
    private static final int CHRONOLOGICAL = 0;
    private static final int RANDOM = 1;
    private static final int NUMBER_OF_MISSING_VALUES = 2;
    private static final int INFORMATION_GAIN = 3;
    private static final String[] orderStrategies = new String[]{"chronological", "random", "number of missing values", "information gain"};
    private static final int ASCENDING = 0;
    private static final String[] sortStrategies = new String[]{"ascending", "descending"};
    private final InputPort exampleSetInput = this.getInputPorts().createPort("example set in", ExampleSet.class);
    private final OutputPort innerExampleSetSource = (OutputPort)this.getSubprocess(0).getInnerSources().createPort("example set source");
    private final InputPort innerModelSink = (InputPort)this.getSubprocess(0).getInnerSinks().createPort("model sink");
    private final OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set out");
    private final AttributeSubsetSelector attributeSelector = new AttributeSubsetSelector(this, this.exampleSetInput);

    public MissingValueImputation(OperatorDescription description) {
        super(description, "Replacement Learning");
        this.getTransformer().addRule(new ExampleSetPassThroughRule(this.exampleSetInput, this.innerExampleSetSource, SetRelation.SUBSET){

            @Override
            public ExampleSetMetaData modifyExampleSet(ExampleSetMetaData metaData) {
                ExampleSetMetaData selectedSubset = MissingValueImputation.this.attributeSelector.getMetaDataSubset(metaData, false);
                if (selectedSubset != null) {
                    Iterator<AttributeMetaData> iterator = selectedSubset.getAllAttributes().iterator();
                    while (iterator.hasNext()) {
                        if (!iterator.next().isSpecial()) continue;
                        iterator.remove();
                    }
                    if (MissingValueImputation.this.getParameterAsBoolean(MissingValueImputation.PARAMETER_LEARN_ON_COMPLETE_CASES)) {
                        for (AttributeMetaData attribute : selectedSubset.getAllAttributes()) {
                            attribute.setNumberOfMissingValues(new MDInteger(0));
                        }
                    }
                    if ((iterator = selectedSubset.getAllAttributes().iterator()).hasNext()) {
                        iterator.next().setRole("label");
                    }
                }
                return selectedSubset == null ? metaData : selectedSubset;
            }
        });
        this.getTransformer().addRule(new SubprocessTransformRule(this.getSubprocess(0)));
        this.getTransformer().addRule(new ExampleSetPassThroughRule(this.exampleSetInput, this.exampleSetOutput, SetRelation.EQUAL){

            @Override
            public ExampleSetMetaData modifyExampleSet(ExampleSetMetaData metaData) {
                ExampleSetMetaData subset = MissingValueImputation.this.attributeSelector.getMetaDataSubset(metaData, false);
                if (subset != null) {
                    for (AttributeMetaData attribute : subset.getAllAttributes()) {
                        metaData.getAttributeByName(attribute.getName()).setNumberOfMissingValues(new MDInteger(0));
                    }
                }
                return metaData;
            }
        });
    }

    @Override
    public void doWork() throws OperatorException {
        Attribute attribute;
        int i;
        boolean iterate = this.getParameterAsBoolean(PARAMETER_ITERATE);
        int order = this.getParameterAsInt(PARAMETER_ORDER);
        boolean ascending = this.getParameterAsInt(PARAMETER_SORT) == 0;
        boolean learnOnCompleteCases = this.getParameterAsBoolean(PARAMETER_LEARN_ON_COMPLETE_CASES);
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInput.getData();
        Attribute label = exampleSet.getAttributes().getLabel();
        if (label != null) {
            exampleSet.getAttributes().setLabel(null);
            exampleSet.getAttributes().remove(label);
        }
        ExampleSet imputationSet = (ExampleSet)exampleSet.clone();
        imputationSet = this.attributeSelector.getSubset(exampleSet, false);
        int numberOfAttributes = imputationSet.getAttributes().size();
        Attribute[][] attributePairs = new Attribute[2][numberOfAttributes];
        imputationSet.getAttributes().setLabel(label);
        attributePairs[0] = this.getOrderedAttributes(imputationSet, order, ascending);
        imputationSet.getAttributes().setLabel(null);
        int imputationFailure = 0;
        ExampleSet workingSet = null;
        for (i = 0; i < numberOfAttributes; ++i) {
            workingSet = (ExampleSet)imputationSet.clone();
            attribute = attributePairs[0][i];
            workingSet.getAttributes().setLabel(attribute);
            Condition condition = null;
            try {
                condition = ConditionedExampleSet.createCondition("no_missing_labels", workingSet, "");
            }
            catch (ConditionCreationException e) {
                throw new UserError((Operator)this, 904, "no_missing_lables", e.getMessage());
            }
            ConditionedExampleSet learningSet = new ConditionedExampleSet(workingSet, condition);
            if (learnOnCompleteCases) {
                try {
                    condition = ConditionedExampleSet.createCondition("no_missing_attributes", learningSet, "");
                }
                catch (ConditionCreationException e) {
                    throw new UserError((Operator)this, 904, "no_missing_attributes", e.getMessage());
                }
                learningSet = new ConditionedExampleSet(learningSet, condition);
            }
            this.log("Learning imputation model for attribute " + attribute.getName() + " on " + learningSet.size() + " examples.");
            this.innerExampleSetSource.deliver(learningSet);
            this.getSubprocess(0).execute();
            Model model = (Model)this.innerModelSink.getData();
            workingSet = model.apply(workingSet);
            workingSet.getAttributes().setLabel(null);
            workingSet.getAttributes().addRegular(attribute);
            attributePairs[1][i] = workingSet.getAttributes().getPredictedLabel();
            if (iterate) {
                this.log("Imputating missing values in attribute " + attribute.getName() + ".");
                for (Example example : workingSet) {
                    double value = example.getValue(attribute);
                    if (!Double.isNaN(value)) continue;
                    example.setValue(attribute, example.getPredictedLabel());
                    if (!Double.isNaN(example.getPredictedLabel())) continue;
                    ++imputationFailure;
                }
            }
            if (imputationFailure > 0) {
                this.logWarning("Unable to impute " + imputationFailure + " missing values in attribute " + attribute.getName() + ".");
                imputationFailure = 0;
            }
            workingSet.getAttributes().setPredictedLabel(null);
        }
        if (!iterate) {
            for (i = 0; i < numberOfAttributes; ++i) {
                imputationFailure = 0;
                attribute = attributePairs[0][i];
                this.log("Imputating missing values in attribute " + attribute.getName() + ".");
                for (Example example : workingSet) {
                    double value = example.getValue(attribute);
                    if (!Double.isNaN(value)) continue;
                    example.setValue(attribute, example.getValue(attributePairs[1][i]));
                    if (!Double.isNaN(example.getValue(attributePairs[1][i]))) continue;
                    ++imputationFailure;
                }
                if (imputationFailure <= 0) continue;
                this.logWarning("Unable to impute " + imputationFailure + " missing values in attribute " + attribute.getName() + ".");
                imputationFailure = 0;
            }
        }
        exampleSet.getAttributes().addRegular(label);
        exampleSet.getAttributes().setLabel(label);
        this.exampleSetOutput.deliver(exampleSet);
    }

    private Attribute[] getOrderedAttributes(ExampleSet exampleSet, int order, boolean ascending) throws OperatorException {
        Attribute[] sortedAttributes = new Attribute[exampleSet.getAttributes().size()];
        AttributeWeights weights = new AttributeWeights(exampleSet);
        switch (order) {
            case 0: {
                int index = 0;
                for (Attribute attribute : exampleSet.getAttributes()) {
                    weights.setWeight(attribute.getName(), index);
                    ++index;
                }
                break;
            }
            case 1: {
                RandomGenerator randomGenerator = RandomGenerator.getRandomGenerator(this);
                for (Attribute attribute : exampleSet.getAttributes()) {
                    weights.setWeight(attribute.getName(), randomGenerator.nextDouble());
                }
                break;
            }
            case 2: {
                exampleSet.recalculateAllAttributeStatistics();
                for (Attribute attribute : exampleSet.getAttributes()) {
                    weights.setWeight(attribute.getName(), exampleSet.getStatistics(attribute, "unknown"));
                }
                break;
            }
            case 3: {
                InfoGainWeighting infoGainWeightingOperator;
                if (exampleSet.getAttributes().getLabel() == null) {
                    throw new UserError((Operator)this, 105);
                }
                try {
                    infoGainWeightingOperator = OperatorService.createOperator(InfoGainWeighting.class);
                }
                catch (OperatorCreationException e) {
                    throw new OperatorException("Cannot create info gain weighting operator which is necessary for ordering the attributes.");
                }
                weights = infoGainWeightingOperator.doWork(exampleSet);
            }
        }
        String[] attributeNames = new String[weights.size()];
        weights.getAttributeNames().toArray(attributeNames);
        int sortingOrder = ascending ? -1 : 1;
        weights.sortByWeight(attributeNames, sortingOrder, 1);
        for (int i = 0; i < attributeNames.length; ++i) {
            sortedAttributes[i] = exampleSet.getAttributes().get(attributeNames[i]);
        }
        return sortedAttributes;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.addAll(this.attributeSelector.getParameterTypes());
        ParameterTypeBoolean type = new ParameterTypeBoolean(PARAMETER_ITERATE, "Impute missing values immediately after having learned the corresponding concept and iterate.", true);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_LEARN_ON_COMPLETE_CASES, "Learn concepts to impute missing values only on the basis of complete cases (should be used in case learning approach can not handle missing values).", true);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeCategory(PARAMETER_ORDER, "Order of attributes in which missing values are estimated.", orderStrategies, 0));
        types.add(new ParameterTypeCategory(PARAMETER_SORT, "Sort direction which is used in order strategy.", sortStrategies, 0));
        types.addAll(RandomGenerator.getRandomGeneratorParameters(this));
        return types;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator((InputPort)this.getInputPorts().getPortByIndex(0), MissingValueImputation.class, this.attributeSelector);
    }
}

