/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.NominalMapping;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.AttributeSetPrecondition;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.preprocessing.AbstractDataProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import java.util.List;
import java.util.Set;

public class MergeNominalValues
extends AbstractDataProcessing {
    public static final String PARAMETER_ATTRIBUTE_NAME = "attribute_name";
    public static final String PARAMETER_FIRST_VALUE = "first_value";
    public static final String PARAMETER_SECOND_VALUE = "second_value";

    public MergeNominalValues(OperatorDescription description) {
        super(description);
        this.getExampleSetInputPort().addPrecondition(new AttributeSetPrecondition(this.getExampleSetInputPort(), AttributeSetPrecondition.getAttributesByParameter(this, PARAMETER_ATTRIBUTE_NAME), new String[0]));
    }

    @Override
    protected MetaData modifyMetaData(ExampleSetMetaData metaData) throws UndefinedParameterError {
        AttributeMetaData targetAttribute = metaData.getAttributeByName(this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME));
        if (targetAttribute != null) {
            Set<String> valueSet = targetAttribute.getValueSet();
            String first = this.getParameterAsString(PARAMETER_FIRST_VALUE);
            String second = this.getParameterAsString(PARAMETER_SECOND_VALUE);
            valueSet.remove(first);
            valueSet.remove(second);
            valueSet.add(first + "_" + second);
        }
        return metaData;
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        String name = this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME);
        Attribute attribute = null;
        for (Attribute current : exampleSet.getAttributes()) {
            if (!current.getName().equals(name)) continue;
            if (!current.isNominal()) {
                throw new UserError((Operator)this, 119, name, this.getName());
            }
            attribute = current;
            break;
        }
        if (attribute == null) {
            throw new UserError((Operator)this, 111, name);
        }
        String firstValue = this.getParameterAsString(PARAMETER_FIRST_VALUE);
        String secondValue = this.getParameterAsString(PARAMETER_SECOND_VALUE);
        this.mergeValues(exampleSet, attribute, firstValue, secondValue);
        return exampleSet;
    }

    private void mergeValues(ExampleSet exampleSet, Attribute attribute, String firstValue, String secondValue) throws OperatorException {
        Attribute newAttribute = AttributeFactory.createAttribute(attribute, "merged");
        NominalMapping mapping = (NominalMapping)attribute.getMapping().clone();
        mapping.clear();
        newAttribute.setMapping(mapping);
        exampleSet.getExampleTable().addAttribute(newAttribute);
        exampleSet.getAttributes().addRegular(newAttribute);
        double first = attribute.getMapping().mapString(firstValue);
        double second = attribute.getMapping().mapString(secondValue);
        String firstPlusSecondString = firstValue + "_" + secondValue;
        for (Example example : exampleSet) {
            double value = example.getValue(attribute);
            if (Double.isNaN(value)) {
                example.setValue(newAttribute, Double.NaN);
            } else if (value == first || value == second) {
                example.setValue(newAttribute, newAttribute.getMapping().mapString(firstPlusSecondString));
            } else {
                example.setValue(newAttribute, newAttribute.getMapping().mapString(attribute.getMapping().mapIndex((int)value)));
            }
            this.checkForStop();
        }
        exampleSet.getAttributes().remove(attribute);
        newAttribute.setName(attribute.getName());
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeAttribute(PARAMETER_ATTRIBUTE_NAME, "The name of the nominal attribute which values should be merged.", this.getExampleSetInputPort(), false));
        types.add(new ParameterTypeString(PARAMETER_FIRST_VALUE, "The first value which should be merged.", false));
        types.add(new ParameterTypeString(PARAMETER_SECOND_VALUE, "The second value which should be merged.", false));
        return types;
    }

    @Override
    public boolean writesIntoExistingData() {
        return false;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), MergeNominalValues.class, null);
    }
}

