/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.preprocessing.AbstractDataProcessing;
import com.rapidminer.operator.tools.AttributeSubsetSelector;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class InternalBinominalRemapping
extends AbstractDataProcessing {
    public static final String PARAMETER_ATTRIBUTES = "attributes";
    public static final String PARAMETER_APPLY_TO_SPECIAL_FEATURES = "apply_to_special_features";
    public static final String PARAMETER_NEGATIVE_VALUE = "negative_value";
    public static final String PARAMETER_POSITIVE_VALUE = "positive_value";
    private AttributeSubsetSelector attributeSelector = new AttributeSubsetSelector(this, this.getInputPort(), 6);

    public InternalBinominalRemapping(OperatorDescription description) {
        super(description);
        this.getExampleSetInputPort().addPrecondition(this.attributeSelector.makePrecondition());
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        String negativeValue = this.getParameterAsString(PARAMETER_NEGATIVE_VALUE);
        String positiveValue = this.getParameterAsString(PARAMETER_POSITIVE_VALUE);
        Set<Attribute> attributes = this.attributeSelector.getAttributeSubset(exampleSet, false);
        HashMap mappings = new HashMap();
        for (Attribute attribute : attributes) {
            if (negativeValue.equals(attribute.getMapping().getNegativeString()) && positiveValue.equals(attribute.getMapping().getPositiveString())) continue;
            if (negativeValue.equals(attribute.getMapping().getPositiveString()) && positiveValue.equals(attribute.getMapping().getNegativeString())) {
                HashMap<Double, Double> mapping = new HashMap<Double, Double>();
                mapping.put(0.0, 1.0);
                mapping.put(1.0, 0.0);
                mappings.put(attribute, mapping);
                attribute.getMapping().clear();
                attribute.getMapping().mapString(negativeValue);
                attribute.getMapping().mapString(positiveValue);
                continue;
            }
            this.logWarning("specified values do not match values of attribute " + attribute.getName() + ", attribute is skipped.");
        }
        for (Example example : exampleSet) {
            for (Attribute attribute : attributes) {
                Double mappedValue;
                double value;
                HashMap mapping = (HashMap)mappings.get(attribute);
                if (mapping == null || Double.isNaN(value = example.getValue(attribute)) || (mappedValue = (Double)mapping.get(value)) == null) continue;
                example.setValue(attribute, mappedValue);
            }
        }
        return exampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.addAll(this.attributeSelector.getParameterTypes());
        types.add(new ParameterTypeString(PARAMETER_NEGATIVE_VALUE, "The first/negative/false value.", false));
        types.add(new ParameterTypeString(PARAMETER_POSITIVE_VALUE, "The second/positive/true value.", false));
        return types;
    }

    @Override
    public boolean writesIntoExistingData() {
        return false;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), InternalBinominalRemapping.class, this.attributeSelector);
    }
}

