/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.preprocessing.filter.ValueReplenishment;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class InfiniteValueReplenishment
extends ValueReplenishment {
    public static final String PARAMETER_REPLENISHMENT_VALUE = "replenishment_value";
    public static final String PARAMETER_REPLENISHMENT_WHAT = "replenish_what";
    private static final int NONE = 0;
    private static final int ZERO = 1;
    private static final int MAX_BYTE = 2;
    private static final int MAX_INT = 3;
    private static final int MAX_DOUBLE = 4;
    private static final int MISSING = 5;
    private static final int VALUE = 6;
    private static final String[] REP_NAMES = new String[]{"none", "zero", "max_byte", "max_int", "max_double", "missing", "value"};
    private static final String[] WHAT_NAMES = new String[]{"positive_infinity", "negative_infinity"};

    public InfiniteValueReplenishment(OperatorDescription description) {
        super(description);
    }

    @Override
    protected Collection<AttributeMetaData> modifyAttributeMetaData(ExampleSetMetaData emd, AttributeMetaData amd) throws UndefinedParameterError {
        return Collections.singletonList(amd);
    }

    @Override
    public double getReplacedValue() {
        try {
            int chosen = this.getParameterAsInt(PARAMETER_REPLENISHMENT_WHAT);
            if (chosen == 0) {
                return Double.POSITIVE_INFINITY;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    protected int[] getFilterValueTypes() {
        return new int[]{2};
    }

    @Override
    public String[] getFunctionNames() {
        return REP_NAMES;
    }

    @Override
    public int getDefaultFunction() {
        return 4;
    }

    @Override
    public int getDefaultColumnFunction() {
        return 1;
    }

    @Override
    public double getReplenishmentValue(int functionIndex, ExampleSet exampleSet, Attribute attribute) throws UndefinedParameterError {
        int chosen = this.getParameterAsInt(PARAMETER_REPLENISHMENT_WHAT);
        switch (functionIndex) {
            case 0: {
                return Double.POSITIVE_INFINITY;
            }
            case 1: {
                return 0.0;
            }
            case 2: {
                return chosen == 0 ? 127.0 : -128.0;
            }
            case 3: {
                return chosen == 0 ? 2.147483647E9 : -2.147483648E9;
            }
            case 4: {
                return chosen == 0 ? Double.MAX_VALUE : -1.7976931348623157E308;
            }
            case 5: {
                return Double.NaN;
            }
            case 6: {
                return this.getParameterAsDouble(PARAMETER_REPLENISHMENT_VALUE);
            }
        }
        throw new RuntimeException("Illegal value functionIndex: " + functionIndex);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeCategory(PARAMETER_REPLENISHMENT_WHAT, "Decides if positive or negative infite values will be replaced.", WHAT_NAMES, 0, false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_REPLENISHMENT_VALUE, "This value will be inserted instead of infinity.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, true);
        type.registerDependencyCondition(new EqualTypeCondition(this, "default", this.getFunctionNames(), true, 6));
        types.add(type);
        return types;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), InfiniteValueReplenishment.class, this.attributeSelector);
    }
}

