/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.AbstractExampleSetProcessing;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetPrecondition;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.preprocessing.filter.Sorting;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.tools.Ontology;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import com.rapidminer.tools.OperatorService;
import com.rapidminer.tools.math.MathFunctions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class FillDataGaps
extends AbstractExampleSetProcessing {
    public static final String PARAMETER_USE_GCD_FOR_STEP_SIZE = "use_gcd_for_step_size";
    public static final String PARAMETER_STEP_SIZE = "step_size";
    public static final String PARAMETER_START = "start";
    public static final String PARAMETER_END = "end";

    public FillDataGaps(OperatorDescription description) {
        super(description);
        this.getExampleSetInputPort().addPrecondition(new ExampleSetPrecondition(this.getExampleSetInputPort(), 0, "id"));
    }

    @Override
    protected MetaData modifyMetaData(ExampleSetMetaData metaData) throws UndefinedParameterError {
        metaData.getNumberOfExamples().increaseByUnknownAmount();
        for (AttributeMetaData amd : metaData.getAllAttributes()) {
            if (amd.getRole() != null && amd.getRole().equals("id")) continue;
            amd.getNumberOfMissingValues().increaseByUnknownAmount();
        }
        return metaData;
    }

    @Override
    public ExampleSet apply(ExampleSet inputSet) throws OperatorException {
        long end;
        long start;
        Attribute idAttribute = inputSet.getAttributes().getId();
        if (idAttribute == null) {
            throw new UserError((Operator)this, 129);
        }
        if (!Ontology.ATTRIBUTE_VALUE_TYPE.isA(idAttribute.getValueType(), 9) && !Ontology.ATTRIBUTE_VALUE_TYPE.isA(idAttribute.getValueType(), 3)) {
            throw new UserError((Operator)this, 120, idAttribute.getName(), new Object[]{Ontology.VALUE_TYPE_NAMES[idAttribute.getValueType()], Ontology.VALUE_TYPE_NAMES[9] + " or " + Ontology.VALUE_TYPE_NAMES[3]});
        }
        Sorting sorting = null;
        try {
            sorting = OperatorService.createOperator(Sorting.class);
        }
        catch (OperatorCreationException e) {
            throw new OperatorException(this.getName() + ": Cannot create discretization operator (" + e + ").");
        }
        sorting.setParameter("attribute_name", idAttribute.getName());
        ExampleSet sortedSet = sorting.apply(inputSet);
        long stepSize = 1L;
        if (!this.getParameterAsBoolean(PARAMETER_USE_GCD_FOR_STEP_SIZE)) {
            stepSize = this.getParameterAsInt(PARAMETER_STEP_SIZE);
        } else {
            int endValue;
            LinkedList<Long> distances = new LinkedList<Long>();
            boolean first = true;
            long lastValue = 0L;
            if (this.isParameterSet(PARAMETER_START)) {
                first = false;
                lastValue = this.getParameterAsInt(PARAMETER_START);
            }
            for (Example example : sortedSet) {
                long value = (long)example.getValue(idAttribute);
                if (first) {
                    first = false;
                } else if (value > lastValue) {
                    distances.add(value - lastValue);
                }
                lastValue = value;
            }
            if (this.isParameterSet(PARAMETER_END) && (long)(endValue = this.getParameterAsInt(PARAMETER_END)) > lastValue) {
                distances.add((long)endValue - lastValue);
            }
            stepSize = MathFunctions.getGCD(distances);
            distances.clear();
        }
        LinkedList<Long> missingValues = new LinkedList<Long>();
        long lastValue = 0L;
        boolean first = true;
        long minValue = Long.MAX_VALUE;
        long maxValue = -9223372036854775807L;
        for (Example example : sortedSet) {
            long value = (long)example.getValue(idAttribute);
            minValue = Math.min(minValue, value);
            maxValue = Math.max(maxValue, value);
            if (first) {
                first = false;
                lastValue = value;
                continue;
            }
            while (lastValue + stepSize < value) {
                missingValues.add(lastValue += stepSize);
            }
            lastValue = value;
        }
        if (this.isParameterSet(PARAMETER_START) && (start = (long)this.getParameterAsInt(PARAMETER_START)) < minValue) {
            lastValue = start;
            while (lastValue + stepSize <= minValue) {
                missingValues.add(lastValue);
                lastValue += stepSize;
            }
        }
        if (this.isParameterSet(PARAMETER_END) && (end = (long)this.getParameterAsInt(PARAMETER_END)) > maxValue) {
            for (lastValue = maxValue + stepSize; lastValue <= end; lastValue += stepSize) {
                missingValues.add(lastValue);
            }
        }
        ArrayList<Attribute> attributes = new ArrayList<Attribute>(sortedSet.getAttributes().allSize());
        HashMap<Attribute, String> specialAttributes = new HashMap<Attribute, String>();
        Iterator<AttributeRole> a = sortedSet.getAttributes().allAttributeRoles();
        int idIndex = -1;
        int index = 0;
        while (a.hasNext()) {
            AttributeRole role = a.next();
            Attribute cloneAttribute = (Attribute)role.getAttribute().clone();
            attributes.add(cloneAttribute);
            if (role.isSpecial()) {
                specialAttributes.put(cloneAttribute, role.getSpecialName());
                if (role.getSpecialName().equals("id")) {
                    idIndex = index;
                }
            }
            ++index;
        }
        MemoryExampleTable table = new MemoryExampleTable(attributes);
        for (Example example : sortedSet) {
            double[] data = new double[attributes.size()];
            index = 0;
            Iterator<Attribute> i = sortedSet.getAttributes().allAttributes();
            while (i.hasNext()) {
                data[index++] = example.getValue(i.next());
            }
            table.addDataRow(new DoubleArrayDataRow(data));
        }
        Iterator<Object> i$ = missingValues.iterator();
        while (i$.hasNext()) {
            long missingValue = (Long)i$.next();
            double[] data = new double[attributes.size()];
            for (int d = 0; d < data.length; ++d) {
                data[d] = Double.NaN;
            }
            data[idIndex] = missingValue;
            table.addDataRow(new DoubleArrayDataRow(data));
        }
        ExampleSet resultSet = table.createExampleSet(specialAttributes);
        resultSet = sorting.apply(resultSet);
        return resultSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean(PARAMETER_USE_GCD_FOR_STEP_SIZE, "Indicates if the greatest common divisor should be calculated and used as the underlying distance between all data points.", true));
        ParameterTypeInt type = new ParameterTypeInt(PARAMETER_STEP_SIZE, "The used step size for filling the gaps (only used if GCD calculation is not checked).", 1, Integer.MAX_VALUE, 1);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_USE_GCD_FOR_STEP_SIZE, false, false));
        types.add(type);
        types.add(new ParameterTypeInt(PARAMETER_START, "If this parameter is defined gaps at the beginning (if they occur) before the first data point will also be filled.", 1, Integer.MAX_VALUE, true));
        types.add(new ParameterTypeInt(PARAMETER_END, "If this parameter is defined gaps at the end (if they occur) after the last data point will also be filled.", 1, Integer.MAX_VALUE, true));
        return types;
    }

    @Override
    public boolean writesIntoExistingData() {
        return false;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), FillDataGaps.class, null);
    }
}

