/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.preprocessing.filter.FeatureFilter;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.tools.Ontology;
import java.util.List;

public class FeatureValueTypeFilter
extends FeatureFilter {
    public static final String PARAMETER_SKIP_FEATURES_OF_TYPE = "skip_features_of_type";
    public static final String PARAMETER_EXCEPT_FEATURES_OF_TYPE = "except_features_of_type";

    public FeatureValueTypeFilter(OperatorDescription description) {
        super(description);
    }

    @Override
    public boolean switchOffFeature(AttributeRole role) throws OperatorException {
        Attribute feature = role.getAttribute();
        int type = this.getParameterAsInt(PARAMETER_SKIP_FEATURES_OF_TYPE) + 1;
        int exceptionType = this.getParameterAsInt(PARAMETER_EXCEPT_FEATURES_OF_TYPE);
        if (exceptionType == 0) {
            return Ontology.ATTRIBUTE_VALUE_TYPE.isA(feature.getValueType(), type);
        }
        return Ontology.ATTRIBUTE_VALUE_TYPE.isA(feature.getValueType(), type) && !Ontology.ATTRIBUTE_VALUE_TYPE.isA(feature.getValueType(), exceptionType);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        String[] valueTypes = new String[Ontology.VALUE_TYPE_NAMES.length - 1];
        for (int i = 0; i < valueTypes.length; ++i) {
            valueTypes[i] = Ontology.VALUE_TYPE_NAMES[i + 1];
        }
        ParameterTypeCategory type = new ParameterTypeCategory(PARAMETER_SKIP_FEATURES_OF_TYPE, "All features of this type will be deselected.", valueTypes, 0);
        type.setExpert(false);
        types.add(type);
        String[] exceptionValueTypes = new String[valueTypes.length + 1];
        exceptionValueTypes[0] = "none";
        System.arraycopy(valueTypes, 0, exceptionValueTypes, 1, valueTypes.length);
        types.add(new ParameterTypeCategory(PARAMETER_EXCEPT_FEATURES_OF_TYPE, "All features of this type will not be deselected.", exceptionValueTypes, 0));
        return types;
    }
}

