/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.preprocessing.filter.FeatureFilter;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class FeatureNameFilter
extends FeatureFilter {
    public static final String PARAMETER_SKIP_FEATURES_WITH_NAME = "skip_features_with_name";
    public static final String PARAMETER_EXCEPT_FEATURES_WITH_NAME = "except_features_with_name";
    private Pattern skipPattern;
    private Pattern exceptionPattern;

    public FeatureNameFilter(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        String regex = this.getParameterAsString(PARAMETER_SKIP_FEATURES_WITH_NAME);
        try {
            this.skipPattern = Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            throw new UserError((Operator)this, 206, regex, e.getMessage());
        }
        regex = this.getParameterAsString(PARAMETER_EXCEPT_FEATURES_WITH_NAME);
        if (regex == null || regex.trim().length() == 0) {
            this.exceptionPattern = null;
        } else {
            try {
                this.exceptionPattern = Pattern.compile(regex);
            }
            catch (PatternSyntaxException e) {
                throw new UserError((Operator)this, 206, regex, e.getMessage());
            }
        }
        return super.apply(exampleSet);
    }

    @Override
    public boolean switchOffFeature(AttributeRole attributeRole) throws OperatorException {
        Attribute attribute = attributeRole.getAttribute();
        Matcher nameSkipMatcher = this.skipPattern.matcher(attribute.getName());
        Matcher specialNameSkipMatcher = null;
        if (attributeRole.isSpecial()) {
            specialNameSkipMatcher = this.skipPattern.matcher(attributeRole.getSpecialName());
        }
        Matcher exceptionMatcher = this.exceptionPattern != null ? this.exceptionPattern.matcher(attribute.getName()) : null;
        Matcher specialExceptionMatcher = null;
        if (attributeRole.isSpecial()) {
            specialExceptionMatcher = this.exceptionPattern != null ? this.exceptionPattern.matcher(attributeRole.getSpecialName()) : null;
        }
        return !(!nameSkipMatcher.matches() && (specialNameSkipMatcher == null || !specialNameSkipMatcher.matches()) || exceptionMatcher != null && exceptionMatcher.matches() || specialExceptionMatcher != null && specialExceptionMatcher.matches());
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString(PARAMETER_SKIP_FEATURES_WITH_NAME, "Remove attributes with a matching name (accepts regular expressions)", false));
        types.add(new ParameterTypeString(PARAMETER_EXCEPT_FEATURES_WITH_NAME, "Does not remove attributes if their name fulfills this matching criterion (accepts regular expressions)", true));
        return types;
    }
}

