/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.features.selection.AbstractFeatureSelection;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import java.util.Iterator;
import java.util.List;

public abstract class FeatureFilter
extends AbstractFeatureSelection {
    public static final String PARAMETER_FILTER_SPECIAL_FEATURES = "filter_special_features";

    public FeatureFilter(OperatorDescription description) {
        super(description);
    }

    public abstract boolean switchOffFeature(AttributeRole var1) throws OperatorException;

    @Override
    public ExampleSet apply(ExampleSet eSet) throws OperatorException {
        this.log(eSet.getAttributes().size() + " features before filtering.");
        Iterator<AttributeRole> i = eSet.getAttributes().allAttributeRoles();
        boolean filterSpecial = this.getParameterAsBoolean(PARAMETER_FILTER_SPECIAL_FEATURES);
        while (i.hasNext()) {
            AttributeRole role = i.next();
            if (role.isSpecial() && !filterSpecial) continue;
            if (this.switchOffFeature(role)) {
                i.remove();
            }
            this.checkForStop();
        }
        this.log(eSet.getAttributes().size() + " features left after filtering.");
        return eSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean(PARAMETER_FILTER_SPECIAL_FEATURES, "Filter also special attributes (label, id...)", false));
        return types;
    }
}

