/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.AttributeSetPrecondition;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.preprocessing.AbstractDataProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import java.util.List;

public class ExchangeAttributeRoles
extends AbstractDataProcessing {
    public static final String PARAMETER_FIRST_ATTRIBUTE = "first_attribute";
    public static final String PARAMETER_SECOND_ATTRIBUTE = "second_attribute";

    public ExchangeAttributeRoles(OperatorDescription description) {
        super(description);
        this.getExampleSetInputPort().addPrecondition(new AttributeSetPrecondition(this.getExampleSetInputPort(), AttributeSetPrecondition.getAttributesByParameter(this, PARAMETER_FIRST_ATTRIBUTE, PARAMETER_SECOND_ATTRIBUTE), new String[0]));
    }

    @Override
    protected MetaData modifyMetaData(ExampleSetMetaData metaData) {
        try {
            AttributeMetaData amd1 = metaData.getAttributeByName(this.getParameterAsString(PARAMETER_FIRST_ATTRIBUTE));
            AttributeMetaData amd2 = metaData.getAttributeByName(this.getParameterAsString(PARAMETER_SECOND_ATTRIBUTE));
            if (amd1 != null && amd2 != null) {
                String role1 = amd1.getRole();
                amd1.setRole(amd2.getRole());
                amd2.setRole(role1);
            }
        }
        catch (UndefinedParameterError undefinedParameterError) {
            // empty catch block
        }
        return metaData;
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        String firstName = this.getParameterAsString(PARAMETER_FIRST_ATTRIBUTE);
        String secondName = this.getParameterAsString(PARAMETER_SECOND_ATTRIBUTE);
        AttributeRole firstRole = exampleSet.getAttributes().getRole(firstName);
        AttributeRole secondRole = exampleSet.getAttributes().getRole(secondName);
        if (firstRole == null) {
            throw new UserError((Operator)this, 111, firstName);
        }
        if (secondRole == null) {
            throw new UserError((Operator)this, 111, secondName);
        }
        String firstRoleName = firstRole.getSpecialName();
        String secondRoleName = secondRole.getSpecialName();
        firstRole.changeToRegular();
        secondRole.changeToRegular();
        firstRole.setSpecial(secondRoleName);
        secondRole.setSpecial(firstRoleName);
        return exampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeAttribute(PARAMETER_FIRST_ATTRIBUTE, "The name of the first attribute for the attribute role exchange.", this.getExampleSetInputPort(), false));
        types.add(new ParameterTypeAttribute(PARAMETER_SECOND_ATTRIBUTE, "The name of the first attribute for the attribute role exchange.", this.getExampleSetInputPort(), false));
        return types;
    }

    @Override
    public boolean writesIntoExistingData() {
        return false;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), ExchangeAttributeRoles.class, null);
    }
}

