/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetPrecondition;
import com.rapidminer.operator.ports.metadata.MetaDataInfo;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.ports.metadata.SimpleMetaDataError;
import com.rapidminer.operator.preprocessing.PreprocessingModel;
import com.rapidminer.operator.preprocessing.PreprocessingOperator;
import com.rapidminer.operator.preprocessing.filter.Dictionary;
import com.rapidminer.operator.tools.AttributeSubsetSelector;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class ExampleSetToDictionary
extends PreprocessingOperator {
    private static final String PARAMETER_REGEXP = "use_regular_expressions";
    private static final String PARAMETER_TO_LOWERCASE = "convert_to_lowercase";
    private static final String PARAMETER_FROM_ATTRIBUTE = "from_attribute";
    private static final String PARAMETER_TO_ATTRIBUTE = "to_attribute";
    private final InputPort dictionaryInput = (InputPort)this.getInputPorts().createPort("dictionary");

    public ExampleSetToDictionary(OperatorDescription description) {
        super(description);
        this.dictionaryInput.addPrecondition(new ExampleSetPrecondition(this.dictionaryInput){

            @Override
            public void makeAdditionalChecks(ExampleSetMetaData dictionaryMD) throws UndefinedParameterError {
                if (dictionaryMD.getAttributeSetRelation() == SetRelation.EQUAL || dictionaryMD.getAttributeSetRelation() == SetRelation.SUPERSET) {
                    String from = ExampleSetToDictionary.this.getParameterAsString(ExampleSetToDictionary.PARAMETER_FROM_ATTRIBUTE);
                    String to = ExampleSetToDictionary.this.getParameterAsString(ExampleSetToDictionary.PARAMETER_TO_ATTRIBUTE);
                    if (dictionaryMD.containsAttributeName(from) != MetaDataInfo.YES) {
                        ExampleSetToDictionary.this.dictionaryInput.addError(new SimpleMetaDataError(ProcessSetupError.Severity.ERROR, (Port)ExampleSetToDictionary.this.dictionaryInput, "missing_attribute", from));
                    }
                    if (dictionaryMD.containsAttributeName(to) != MetaDataInfo.YES) {
                        ExampleSetToDictionary.this.dictionaryInput.addError(new SimpleMetaDataError(ProcessSetupError.Severity.ERROR, (Port)ExampleSetToDictionary.this.dictionaryInput, "missing_attribute", to));
                    }
                }
            }
        });
    }

    @Override
    protected ExampleSetMetaData modifyMetaData(ExampleSetMetaData exampleSetMetaData) throws UndefinedParameterError {
        AttributeSubsetSelector selector = new AttributeSubsetSelector(this, this.getExampleSetInputPort());
        ExampleSetMetaData subset = selector.getMetaDataSubset(exampleSetMetaData, false);
        for (AttributeMetaData amd : subset.getAllAttributes()) {
            if (!amd.isNominal()) continue;
            AttributeMetaData originalAttribute = exampleSetMetaData.getAttributeByName(amd.getName());
            originalAttribute.setValueSet(new HashSet<String>(0), SetRelation.UNKNOWN);
        }
        return super.modifyMetaData(exampleSetMetaData);
    }

    @Override
    protected Collection<AttributeMetaData> modifyAttributeMetaData(ExampleSetMetaData emd, AttributeMetaData amd) {
        return null;
    }

    @Override
    public PreprocessingModel createPreprocessingModel(ExampleSet exampleSet) throws OperatorException {
        ExampleSet dictionarySet = (ExampleSet)this.dictionaryInput.getData();
        AttributeSubsetSelector subsetSelector = new AttributeSubsetSelector(this, this.getExampleSetInputPort());
        boolean toLowerCase = this.getParameterAsBoolean(PARAMETER_TO_LOWERCASE);
        LinkedList<String[]> replacements = new LinkedList<String[]>();
        Attribute from = dictionarySet.getAttributes().get(this.getParameterAsString(PARAMETER_FROM_ATTRIBUTE));
        Attribute to = dictionarySet.getAttributes().get(this.getParameterAsString(PARAMETER_TO_ATTRIBUTE));
        if (!from.isNominal()) {
            throw new UserError((Operator)this, 119, from.getName(), this);
        }
        if (!to.isNominal()) {
            throw new UserError((Operator)this, 119, to.getName(), this);
        }
        for (Example example : dictionarySet) {
            if (toLowerCase) {
                replacements.add(new String[]{example.getValueAsString(from).toLowerCase(), example.getValueAsString(to).toLowerCase()});
                continue;
            }
            replacements.add(new String[]{example.getValueAsString(from), example.getValueAsString(to)});
        }
        return new Dictionary(exampleSet, subsetSelector.getAttributeSubset(exampleSet, false), replacements, this.getParameterAsBoolean(PARAMETER_REGEXP), toLowerCase);
    }

    @Override
    public Class<? extends PreprocessingModel> getPreprocessingModelClass() {
        return Dictionary.class;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeAttribute(PARAMETER_FROM_ATTRIBUTE, "Name of the attribute that specifies what is replaced.", this.dictionaryInput, false, 1));
        types.add(new ParameterTypeAttribute(PARAMETER_TO_ATTRIBUTE, "Name of the attribute that specifies replacements.", this.dictionaryInput, false, 1));
        types.add(new ParameterTypeBoolean(PARAMETER_REGEXP, "Choose whether the replacements are treated as regular expressions.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_TO_LOWERCASE, "Choose whether the strings are converted to lower case.", false));
        return types;
    }

    @Override
    protected int[] getFilterValueTypes() {
        return new int[]{0};
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), ExampleSetToDictionary.class, this.attributeSelector);
    }
}

