/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.Partition;
import com.rapidminer.example.set.SplittedExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetSizePrecondition;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.preprocessing.AbstractDataProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import java.util.List;

public class ExampleRangeFilter
extends AbstractDataProcessing {
    public static final String PARAMETER_FIRST_EXAMPLE = "first_example";
    public static final String PARAMETER_LAST_EXAMPLE = "last_example";
    public static final String PARAMETER_INVERT_FILTER = "invert_filter";

    public ExampleRangeFilter(OperatorDescription description) {
        super(description);
        this.getExampleSetInputPort().addPrecondition(new ExampleSetSizePrecondition(this.getExampleSetInputPort(), this, PARAMETER_FIRST_EXAMPLE, PARAMETER_LAST_EXAMPLE));
    }

    @Override
    protected MetaData modifyMetaData(ExampleSetMetaData metaData) throws UndefinedParameterError {
        if (metaData.getNumberOfExamples().isKnown()) {
            int difference = this.getParameterAsInt(PARAMETER_LAST_EXAMPLE) - this.getParameterAsInt(PARAMETER_FIRST_EXAMPLE);
            if (this.getParameterAsBoolean(PARAMETER_INVERT_FILTER)) {
                difference = (Integer)metaData.getNumberOfExamples().getValue() - difference - 1;
            }
            metaData.setNumberOfExamples(difference);
        }
        return metaData;
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        int[] partition = new int[exampleSet.size()];
        int startIndex = this.getParameterAsInt(PARAMETER_FIRST_EXAMPLE);
        int endIndex = this.getParameterAsInt(PARAMETER_LAST_EXAMPLE);
        if (endIndex < startIndex) {
            throw new UserError((Operator)this, 210, PARAMETER_LAST_EXAMPLE, PARAMETER_FIRST_EXAMPLE);
        }
        for (int i = 0; i < partition.length; ++i) {
            partition[i] = i >= startIndex - 1 && i <= endIndex - 1 ? 0 : 1;
        }
        SplittedExampleSet result = new SplittedExampleSet(exampleSet, new Partition(partition, 2));
        if (this.getParameterAsBoolean(PARAMETER_INVERT_FILTER)) {
            result.selectSingleSubset(1);
        } else {
            result.selectSingleSubset(0);
        }
        return result;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> parameterTypes = super.getParameterTypes();
        parameterTypes.add(new ParameterTypeInt(PARAMETER_FIRST_EXAMPLE, "The first example of the resulting example set.", 1, Integer.MAX_VALUE, false));
        parameterTypes.add(new ParameterTypeInt(PARAMETER_LAST_EXAMPLE, "The last example of the resulting example set.", 1, Integer.MAX_VALUE, false));
        parameterTypes.add(new ParameterTypeBoolean(PARAMETER_INVERT_FILTER, "Indicates if the filter should be inverted.", false));
        return parameterTypes;
    }

    @Override
    public boolean writesIntoExistingData() {
        return false;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), ExampleRangeFilter.class, null);
    }
}

