/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.Condition;
import com.rapidminer.example.set.ConditionCreationException;
import com.rapidminer.example.set.ConditionedExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MDInteger;
import com.rapidminer.operator.preprocessing.AbstractDataProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.ParameterTypeStringCategory;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.EqualStringCondition;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import java.util.List;

public class ExampleFilter
extends AbstractDataProcessing {
    public static final String PARAMETER_CONDITION_CLASS = "condition_class";
    public static final String PARAMETER_PARAMETER_STRING = "parameter_string";
    public static final String PARAMETER_INVERT_FILTER = "invert_filter";

    public ExampleFilter(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSetMetaData modifyMetaData(ExampleSetMetaData emd) {
        emd.getNumberOfExamples().reduceByUnknownAmount();
        try {
            if (this.getParameterAsString(PARAMETER_CONDITION_CLASS).equals(ConditionedExampleSet.KNOWN_CONDITION_NAMES[3])) {
                for (AttributeMetaData amd : emd.getAllAttributes()) {
                    amd.setNumberOfMissingValues(new MDInteger(0));
                }
            }
        }
        catch (UndefinedParameterError undefinedParameterError) {
            // empty catch block
        }
        return emd;
    }

    @Override
    public ExampleSet apply(ExampleSet inputSet) throws OperatorException {
        this.getLogger().fine(this.getName() + ": input set has " + inputSet.size() + " examples.");
        String className = this.getParameterAsString(PARAMETER_CONDITION_CLASS);
        String parameter = this.getParameterAsString(PARAMETER_PARAMETER_STRING);
        this.getLogger().fine("Creating condition '" + className + "' with parameter '" + parameter + "'");
        Condition condition = null;
        try {
            condition = ConditionedExampleSet.createCondition(className, inputSet, parameter);
        }
        catch (ConditionCreationException e) {
            throw new UserError((Operator)this, (Throwable)e, 904, className, e.getMessage());
        }
        ConditionedExampleSet result = new ConditionedExampleSet(inputSet, condition, this.getParameterAsBoolean(PARAMETER_INVERT_FILTER));
        return result;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeStringCategory(PARAMETER_CONDITION_CLASS, "Implementation of the condition.", ConditionedExampleSet.KNOWN_CONDITION_NAMES, ConditionedExampleSet.KNOWN_CONDITION_NAMES[0], false);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeString(PARAMETER_PARAMETER_STRING, "Parameter string for the condition, e.g. 'attribute=value' for the AttributeValueFilter.", true);
        type.registerDependencyCondition(new EqualStringCondition(this, PARAMETER_CONDITION_CLASS, true, ConditionedExampleSet.KNOWN_CONDITION_NAMES[7]));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_INVERT_FILTER, "Indicates if only examples should be accepted which would normally filtered.", false);
        type.setExpert(false);
        types.add(type);
        return types;
    }

    @Override
    public boolean writesIntoExistingData() {
        return false;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), ExampleFilter.class, null);
    }
}

