/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.AbstractExampleSetProcessing;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MDInteger;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.SimpleMetaDataError;
import com.rapidminer.operator.tools.AttributeSubsetSelector;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import java.util.List;

public class DeclareMissingValueOperator
extends AbstractExampleSetProcessing {
    public static final String PARAMETER_MISSING_VALUE_NUMERIC = "numeric_value";
    public static final String PARAMETER_MISSING_VALUE_NOMINAL = "nominal_value";
    public static final String PARAMETER_MODE = "mode";
    private AttributeSubsetSelector subsetSelector = new AttributeSubsetSelector(this, this.getExampleSetInputPort());
    private static final String NUMERIC = "numeric";
    private static final String NOMINAL = "nominal";
    private static final String[] VALUE_TYPES = new String[]{"numeric", "nominal"};

    public DeclareMissingValueOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    protected MetaData modifyMetaData(ExampleSetMetaData metaData) throws UndefinedParameterError {
        ExampleSetMetaData subset;
        if ((this.isParameterSet(PARAMETER_MISSING_VALUE_NOMINAL) || this.isParameterSet(PARAMETER_MISSING_VALUE_NUMERIC)) && (subset = this.subsetSelector.getMetaDataSubset(metaData, false)) != null) {
            boolean parameterAttributeTypeExistsInSubset = false;
            String mode = this.getParameterAsString(PARAMETER_MODE);
            block6: for (AttributeMetaData amd : subset.getAllAttributes()) {
                AttributeMetaData originalAMD = metaData.getAttributeByName(amd.getName());
                MDInteger missingValueNumber = originalAMD.getNumberOfMissingValues();
                missingValueNumber.increaseByUnknownAmount();
                if (mode.equals(NUMERIC)) {
                    switch (amd.getValueType()) {
                        case 2: 
                        case 3: 
                        case 4: {
                            parameterAttributeTypeExistsInSubset = true;
                            break;
                        }
                        default: {
                            continue block6;
                        }
                    }
                }
                if (!mode.equals(NOMINAL)) continue;
                switch (amd.getValueType()) {
                    case 1: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: {
                        parameterAttributeTypeExistsInSubset = true;
                        continue block6;
                    }
                }
            }
            if (!parameterAttributeTypeExistsInSubset) {
                if (subset.getAllAttributes().size() <= 0) {
                    this.getInputPort().addError(new SimpleMetaDataError(ProcessSetupError.Severity.ERROR, (Port)this.getInputPort(), "attribute_selection_empty", new Object[0]));
                } else {
                    if (mode.equals(NUMERIC)) {
                        this.getInputPort().addError(new SimpleMetaDataError(ProcessSetupError.Severity.ERROR, (Port)this.getInputPort(), "exampleset.must_contain_numerical_attribute", new Object[0]));
                    }
                    if (mode.equals(NOMINAL)) {
                        this.getInputPort().addError(new SimpleMetaDataError(ProcessSetupError.Severity.ERROR, (Port)this.getInputPort(), "exampleset.must_contain_nominal_attribute", new Object[0]));
                    }
                }
            }
        }
        return metaData;
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        ExampleSet subset = this.subsetSelector.getSubset(exampleSet, false);
        Attributes attributes = subset.getAttributes();
        String mode = this.getParameterAsString(PARAMETER_MODE);
        for (Example example : subset) {
            for (Attribute attribute : attributes) {
                if (mode.equals(NUMERIC) && example.getValue(attribute) == this.getParameterAsDouble(PARAMETER_MISSING_VALUE_NUMERIC)) {
                    example.setValue(attribute, Double.NaN);
                }
                if (!mode.equals(NOMINAL) || !example.getNominalValue(attribute).equals(this.getParameterAsString(PARAMETER_MISSING_VALUE_NOMINAL))) continue;
                example.setValue(attribute, Double.NaN);
            }
        }
        return exampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> parameters = super.getParameterTypes();
        parameters.addAll(this.subsetSelector.getParameterTypes());
        ParameterTypeSingle type = new ParameterTypeCategory(PARAMETER_MODE, "Select the value type of the missing value", VALUE_TYPES, 0);
        type.setExpert(false);
        parameters.add(type);
        type = new ParameterTypeDouble(PARAMETER_MISSING_VALUE_NUMERIC, "This parameter defines the missing numerical value", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, true);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_MODE, VALUE_TYPES, true, 0));
        type.setExpert(false);
        parameters.add(type);
        type = new ParameterTypeString(PARAMETER_MISSING_VALUE_NOMINAL, "This parameter defines the missing nominal value", true, false);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_MODE, VALUE_TYPES, true, 1));
        type.setExpert(false);
        parameters.add(type);
        return parameters;
    }

    @Override
    public boolean writesIntoExistingData() {
        return true;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), DeclareMissingValueOperator.class, null);
    }
}

