/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.AttributeSetPrecondition;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.preprocessing.AbstractDataProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.Ontology;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import com.rapidminer.tools.Tools;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class DateAdjust
extends AbstractDataProcessing {
    private static final String ATTRIBUTE_NAME_POSTFIX = "_adjusted";
    public static final String PARAMETER_ATTRIBUTE_NAME = "attribute_name";
    public static final String PARAMETER_KEEP_OLD_ATTRIBUTE = "keep_old_attribute";
    public static final String PARAMETER_ADJUSTMENTS = "adjustments";
    public static final String PARAMETER_DATE_UNIT = "date_unit";
    public static final String[] CALENDAR_FIELDS = new String[]{"Year", "Month", "Day", "Hour", "Minute", "Second", "Millisecond"};
    public static final int CALENDAR_FIELD_YEAR = 0;
    public static final int CALENDAR_FIELD_MONTH = 1;
    public static final int CALENDAR_FIELD_DAY = 2;
    public static final int CALENDAR_FIELD_HOUR = 3;
    public static final int CALENDAR_FIELD_MINUTE = 4;
    public static final int CALENDAR_FIELD_SECOND = 5;
    public static final int CALENDAR_FIELD_MILLISECOND = 6;

    public DateAdjust(OperatorDescription description) {
        super(description);
        this.getExampleSetInputPort().addPrecondition(new AttributeSetPrecondition(this.getExampleSetInputPort(), AttributeSetPrecondition.getAttributesByParameter(this, PARAMETER_ATTRIBUTE_NAME), 9, new String[0]));
    }

    @Override
    protected MetaData modifyMetaData(ExampleSetMetaData metaData) throws UndefinedParameterError {
        AttributeMetaData targetAttribute = metaData.getAttributeByName(this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME));
        if (targetAttribute != null) {
            AttributeMetaData newAttribute = targetAttribute.clone();
            newAttribute.setValueSetRelation(SetRelation.UNKNOWN);
            if (this.getParameterAsBoolean(PARAMETER_KEEP_OLD_ATTRIBUTE)) {
                newAttribute.setName(newAttribute.getName() + ATTRIBUTE_NAME_POSTFIX);
            } else {
                metaData.removeAttribute(targetAttribute);
            }
            metaData.addAttribute(newAttribute);
        }
        return metaData;
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        String attributeName = this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME);
        Attribute dateAttribute = exampleSet.getAttributes().get(attributeName);
        if (dateAttribute == null) {
            throw new UserError((Operator)this, 111, attributeName);
        }
        if (!Ontology.ATTRIBUTE_VALUE_TYPE.isA(dateAttribute.getValueType(), 9)) {
            throw new UserError((Operator)this, 120, attributeName, new Object[]{Ontology.VALUE_TYPE_NAMES[dateAttribute.getValueType()], Ontology.VALUE_TYPE_NAMES[9]});
        }
        Attribute newAttribute = AttributeFactory.createAttribute(dateAttribute.getValueType());
        exampleSet.getExampleTable().addAttribute(newAttribute);
        exampleSet.getAttributes().addRegular(newAttribute);
        LinkedList<Adjustment> adjustments = new LinkedList<Adjustment>();
        List<String[]> adjustmentList = this.getParameterList(PARAMETER_ADJUSTMENTS);
        for (String[] keyValuePair : adjustmentList) {
            int amount = 0;
            try {
                String amountString = keyValuePair[0].trim();
                if (amountString.startsWith("+")) {
                    amountString = amountString.substring(1).trim();
                }
                amount = Integer.parseInt(amountString);
            }
            catch (NumberFormatException e) {
                throw new UserError((Operator)this, 116, PARAMETER_ADJUSTMENTS, "please use only integer numbers for the adjustments");
            }
            int field = -1;
            try {
                field = Integer.parseInt(keyValuePair[1]);
            }
            catch (NumberFormatException e) {
                int index = 0;
                boolean found = false;
                for (String fieldName : CALENDAR_FIELDS) {
                    if (fieldName.equals(keyValuePair[1])) {
                        found = true;
                        break;
                    }
                    ++index;
                }
                if (!found) {
                    throw new UserError((Operator)this, 116, PARAMETER_ADJUSTMENTS, "please use only known calendar units like Year or Hour for the adjustments");
                }
                field = index;
            }
            adjustments.add(new Adjustment(field, amount));
        }
        this.log("Adjustments: " + adjustments);
        Calendar calendar = Tools.getPreferredCalendar();
        for (Example example : exampleSet) {
            Date date = example.getDateValue(dateAttribute);
            calendar.setTime(date);
            for (Adjustment adjustment : adjustments) {
                calendar.add(adjustment.getField(), adjustment.getAmount());
            }
            example.setValue(newAttribute, calendar.getTime().getTime());
        }
        if (!this.getParameterAsBoolean(PARAMETER_KEEP_OLD_ATTRIBUTE)) {
            exampleSet.getAttributes().remove(dateAttribute);
            newAttribute.setName(attributeName);
        } else {
            newAttribute.setName(attributeName + ATTRIBUTE_NAME_POSTFIX);
        }
        return exampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeAttribute(PARAMETER_ATTRIBUTE_NAME, "The attribute which should be parsed.", this.getExampleSetInputPort(), false, 9));
        types.add(new ParameterTypeList(PARAMETER_ADJUSTMENTS, "This list defines all date adjustments.", (ParameterType)new ParameterTypeInt("adjustment", "The number of units to add to the dates.", -2147483647, Integer.MAX_VALUE), (ParameterType)new ParameterTypeCategory(PARAMETER_DATE_UNIT, "The unit which should be adjusted.", CALENDAR_FIELDS, 3)));
        types.add(new ParameterTypeBoolean(PARAMETER_KEEP_OLD_ATTRIBUTE, "Indicates if the original date attribute should be kept.", false));
        return types;
    }

    @Override
    public boolean writesIntoExistingData() {
        return false;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), DateAdjust.class, null);
    }

    private static class Adjustment {
        private int originalField;
        private int calendarField;
        private int amount;

        public Adjustment(int field, int amount) {
            this.originalField = field;
            switch (field) {
                case 0: {
                    this.calendarField = 1;
                    break;
                }
                case 1: {
                    this.calendarField = 2;
                    break;
                }
                case 2: {
                    this.calendarField = 6;
                    break;
                }
                case 3: {
                    this.calendarField = 11;
                    break;
                }
                case 4: {
                    this.calendarField = 12;
                    break;
                }
                case 5: {
                    this.calendarField = 13;
                    break;
                }
                case 6: {
                    this.calendarField = 14;
                }
            }
            this.amount = amount;
        }

        public int getField() {
            return this.calendarField;
        }

        public int getAmount() {
            return this.amount;
        }

        public String toString() {
            return "Adjust " + CALENDAR_FIELDS[this.originalField] + " (calendar: " + this.calendarField + ") by " + this.amount;
        }
    }
}

