/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.AttributeSetPrecondition;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.preprocessing.filter.AbstractDateDataProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import com.rapidminer.tools.Tools;
import java.util.Calendar;
import java.util.List;

public class Date2Numerical
extends AbstractDateDataProcessing {
    public static final String PARAMETER_ATTRIBUTE_NAME = "attribute_name";
    public static final String PARAMETER_TIME_UNIT = "time_unit";
    public static final String PARAMETER_KEEP_OLD_ATTRIBUTE = "keep_old_attribute";
    Calendar calendar = null;

    public Date2Numerical(OperatorDescription description) {
        super(description);
        this.getExampleSetInputPort().addPrecondition(new AttributeSetPrecondition(this.getExampleSetInputPort(), AttributeSetPrecondition.getAttributesByParameter(this, PARAMETER_ATTRIBUTE_NAME), new String[0]));
    }

    @Override
    protected MetaData modifyMetaData(ExampleSetMetaData metaData) throws UndefinedParameterError {
        AttributeMetaData amd = metaData.getAttributeByName(this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME));
        if (amd != null) {
            AttributeMetaData newAttribute = amd.clone();
            newAttribute.setType(3);
            newAttribute.getMean().setUnkown();
            newAttribute.setValueSetRelation(SetRelation.UNKNOWN);
            if (!this.getParameterAsBoolean(PARAMETER_KEEP_OLD_ATTRIBUTE)) {
                metaData.removeAttribute(amd);
            } else {
                newAttribute.setName(newAttribute.getName() + "_" + TIME_UNITS[this.getParameterAsInt(PARAMETER_TIME_UNIT)]);
            }
            metaData.addAttribute(newAttribute);
        }
        return metaData;
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        String attributeName = this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME);
        int timeUnit = this.getParameterAsInt(PARAMETER_TIME_UNIT);
        int relativeTo = this.getParameterAsInt(PARAMETERS_RELATIVE_TO[timeUnit]);
        Attribute dateAttribute = exampleSet.getAttributes().get(attributeName);
        if (dateAttribute == null) {
            throw new UserError((Operator)this, 111, attributeName);
        }
        Attribute newAttribute = AttributeFactory.createAttribute(3);
        exampleSet.getExampleTable().addAttribute(newAttribute);
        exampleSet.getAttributes().addRegular(newAttribute);
        this.calendar = Tools.getPreferredCalendar();
        for (Example example : exampleSet) {
            double value = example.getValue(dateAttribute);
            if (Double.isNaN(value)) {
                example.setValue(newAttribute, value);
                continue;
            }
            example.setValue(newAttribute, this.extract((long)value, timeUnit, relativeTo));
        }
        if (!this.getParameterAsBoolean(PARAMETER_KEEP_OLD_ATTRIBUTE)) {
            exampleSet.getAttributes().remove(dateAttribute);
            newAttribute.setName(attributeName);
        } else {
            newAttribute.setName(attributeName + "_" + TIME_UNITS[timeUnit]);
        }
        return exampleSet;
    }

    private double extract(long milliseconds, int timeUnit, int relativeTo) {
        this.calendar.setTimeInMillis(milliseconds);
        switch (timeUnit) {
            case 0: {
                switch (relativeTo) {
                    case 0: {
                        return milliseconds % 1000L;
                    }
                    case 1: {
                        return milliseconds;
                    }
                }
                break;
            }
            case 1: {
                switch (relativeTo) {
                    case 0: {
                        return this.calendar.get(13);
                    }
                    case 1: {
                        return this.calendar.get(12) * 60 + this.calendar.get(13);
                    }
                    case 2: {
                        return this.calendar.get(11) * 3600 + this.calendar.get(12) * 60 + this.calendar.get(13);
                    }
                    case 3: {
                        return milliseconds / 1000L;
                    }
                }
                break;
            }
            case 2: {
                switch (relativeTo) {
                    case 0: {
                        return this.calendar.get(12);
                    }
                    case 1: {
                        return this.calendar.get(11) * 60 + this.calendar.get(12);
                    }
                    case 2: {
                        return milliseconds / 60000L;
                    }
                }
            }
            case 3: {
                switch (relativeTo) {
                    case 0: {
                        return this.calendar.get(11);
                    }
                    case 1: {
                        return milliseconds / 3600000L;
                    }
                }
                break;
            }
            case 4: {
                switch (relativeTo) {
                    case 0: {
                        return this.calendar.get(7);
                    }
                    case 1: {
                        return this.calendar.get(5);
                    }
                    case 2: {
                        return this.calendar.get(6);
                    }
                    case 3: {
                        return milliseconds / 86400000L;
                    }
                }
                break;
            }
            case 5: {
                switch (relativeTo) {
                    case 0: {
                        return this.calendar.get(4);
                    }
                    case 1: {
                        return this.calendar.get(3);
                    }
                    case 2: {
                        return milliseconds / 604800000L;
                    }
                }
                break;
            }
            case 6: {
                switch (relativeTo) {
                    case 0: {
                        return this.calendar.get(2) % 3 + 1;
                    }
                    case 1: {
                        return this.calendar.get(2) + 1;
                    }
                    case 2: {
                        return this.calendar.get(2) + 1 + (this.calendar.get(1) - 1970) * 12;
                    }
                }
                break;
            }
            case 7: {
                switch (relativeTo) {
                    case 0: {
                        return this.calendar.get(2) / 3 + 1;
                    }
                    case 1: {
                        return this.calendar.get(2) / 3 + 1 + (this.calendar.get(1) - 1970) * 4;
                    }
                }
                break;
            }
            case 8: {
                switch (relativeTo) {
                    case 0: {
                        return this.calendar.get(2) / 6 + 1;
                    }
                    case 1: {
                        return this.calendar.get(2) / 6 + 1 + (this.calendar.get(1) - 1970) * 2;
                    }
                }
                break;
            }
            case 9: {
                switch (relativeTo) {
                    case 1: {
                        return this.calendar.get(1);
                    }
                    case 0: {
                        return this.calendar.get(1) - 1970;
                    }
                }
                break;
            }
        }
        return Double.NaN;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeAttribute(PARAMETER_ATTRIBUTE_NAME, "The attribute which should be parsed.", this.getExampleSetInputPort(), false, false, 9));
        types.add(new ParameterTypeCategory(PARAMETER_TIME_UNIT, "The unit in which the time is measured.", TIME_UNITS, 0, false));
        ParameterTypeCategory type = null;
        int i = 0;
        while (i < TIME_UNITS.length) {
            type = new ParameterTypeCategory(PARAMETERS_RELATIVE_TO[i], "The unit the value is extracted relativ to.", RELATIVE_TO_MODES[i], RELATIVE_TO_DEFAULTS[i], false);
            type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_TIME_UNIT, TIME_UNITS, true, i++));
            types.add(type);
        }
        types.add(new ParameterTypeBoolean(PARAMETER_KEEP_OLD_ATTRIBUTE, "Indicates if the original date attribute should be kept.", false));
        return types;
    }

    @Override
    public boolean writesIntoExistingData() {
        return false;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), Date2Numerical.class, null);
    }
}

