/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.AttributeSetPrecondition;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.preprocessing.filter.AbstractDateDataProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDateFormat;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.ParameterTypeStringCategory;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;

public class Date2Nominal
extends AbstractDateDataProcessing {
    private static final String ATTRIBUTE_NAME_POSTFIX = "_nominal";
    public static final String PARAMETER_ATTRIBUTE_NAME = "attribute_name";
    public static final String PARAMETER_DATE_FORMAT = "date_format";
    public static final String PARAMETER_LOCALE = "locale";
    public static final String PARAMETER_KEEP_OLD_ATTRIBUTE = "keep_old_attribute";

    public Date2Nominal(OperatorDescription description) {
        super(description);
        this.getExampleSetInputPort().addPrecondition(new AttributeSetPrecondition(this.getExampleSetInputPort(), AttributeSetPrecondition.getAttributesByParameter(this, PARAMETER_ATTRIBUTE_NAME), new String[0]));
    }

    @Override
    protected MetaData modifyMetaData(ExampleSetMetaData metaData) throws UndefinedParameterError {
        AttributeMetaData amd = metaData.getAttributeByName(this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME));
        if (amd != null) {
            AttributeMetaData newAmd = new AttributeMetaData(amd.getName(), amd.getValueType(), amd.getRole());
            newAmd.setType(1);
            newAmd.getMean().setUnkown();
            HashSet<String> valueSet = new HashSet<String>();
            if (amd.getValueRange() != null) {
                String dateFormat = this.getParameterAsString(PARAMETER_DATE_FORMAT);
                int localeIndex = this.getParameterAsInt(PARAMETER_LOCALE);
                Locale selectedLocale = Locale.US;
                if (localeIndex >= 0 && localeIndex < availableLocales.size()) {
                    selectedLocale = (Locale)availableLocales.get(this.getParameterAsInt(PARAMETER_LOCALE));
                }
                SimpleDateFormat parser = new SimpleDateFormat(dateFormat, selectedLocale);
                Date date = new Date((long)amd.getValueRange().getLower());
                String newDateStr = parser.format(date);
                valueSet.add(newDateStr);
                date = new Date((long)amd.getValueRange().getUpper());
                newDateStr = parser.format(date);
                valueSet.add(newDateStr);
            }
            newAmd.setValueSet(valueSet, SetRelation.SUPERSET);
            if (!this.getParameterAsBoolean(PARAMETER_KEEP_OLD_ATTRIBUTE)) {
                metaData.removeAttribute(amd);
            } else {
                newAmd.setName(newAmd.getName() + ATTRIBUTE_NAME_POSTFIX);
            }
            metaData.addAttribute(newAmd);
        }
        return metaData;
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        String attributeName = this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME);
        Attribute dateAttribute = exampleSet.getAttributes().get(attributeName);
        if (dateAttribute == null) {
            throw new UserError((Operator)this, 111, attributeName);
        }
        Attribute newAttribute = AttributeFactory.createAttribute(1);
        exampleSet.getExampleTable().addAttribute(newAttribute);
        exampleSet.getAttributes().addRegular(newAttribute);
        String dateFormat = this.getParameterAsString(PARAMETER_DATE_FORMAT);
        int localeIndex = this.getParameterAsInt(PARAMETER_LOCALE);
        Locale selectedLocale = Locale.US;
        if (localeIndex >= 0 && localeIndex < availableLocales.size()) {
            selectedLocale = (Locale)availableLocales.get(this.getParameterAsInt(PARAMETER_LOCALE));
        }
        SimpleDateFormat parser = new SimpleDateFormat(dateFormat, selectedLocale);
        for (Example example : exampleSet) {
            if (Double.isNaN(example.getValue(dateAttribute))) {
                example.setValue(newAttribute, Double.NaN);
                continue;
            }
            Date date = new Date((long)example.getValue(dateAttribute));
            String newDateStr = parser.format(date);
            example.setValue(newAttribute, newAttribute.getMapping().mapString(newDateStr));
        }
        if (!this.getParameterAsBoolean(PARAMETER_KEEP_OLD_ATTRIBUTE)) {
            exampleSet.getAttributes().remove(dateAttribute);
            newAttribute.setName(attributeName);
        } else {
            newAttribute.setName(attributeName + ATTRIBUTE_NAME_POSTFIX);
        }
        return exampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeAttribute attributeParamType = new ParameterTypeAttribute(PARAMETER_ATTRIBUTE_NAME, "The attribute which should be parsed.", this.getExampleSetInputPort(), false, false, 9);
        types.add(attributeParamType);
        ParameterTypeSingle type = new ParameterTypeStringCategory(PARAMETER_DATE_FORMAT, "The output format of the date values, for example \"yyyy/MM/dd\".", ParameterTypeDateFormat.PREDEFINED_DATE_FORMATS);
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_LOCALE, "The used locale for date texts, for example \"Wed\" (English) in contrast to \"Mi\" (German).", availableLocaleNames, defaultLocale);
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_KEEP_OLD_ATTRIBUTE, "Indicates if the original date attribute should be kept.", false));
        return types;
    }

    @Override
    public boolean writesIntoExistingData() {
        return false;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), Date2Nominal.class, null);
    }
}

