/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.AttributeSetPrecondition;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.SimpleMetaDataError;
import com.rapidminer.operator.preprocessing.AbstractDataProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeStringCategory;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import java.util.List;

public class ChangeAttributeRole
extends AbstractDataProcessing {
    public static final String PARAMETER_NAME = "name";
    public static final String PARAMETER_TARGET_ROLE = "target_role";
    public static final String PARAMETER_CHANGE_ATTRIBUTES = "set_additional_roles";
    private static final String REGULAR_NAME = "regular";
    private static final String[] TARGET_ROLES = new String[]{"regular", "id", "label", "prediction", "cluster", "weight", "batch"};

    public ChangeAttributeRole(OperatorDescription description) {
        super(description);
        this.getExampleSetInputPort().addPrecondition(new AttributeSetPrecondition(this.getExampleSetInputPort(), AttributeSetPrecondition.getAttributesByParameter(this, PARAMETER_NAME), new String[0]));
        this.getExampleSetInputPort().addPrecondition(new AttributeSetPrecondition(this.getExampleSetInputPort(), AttributeSetPrecondition.getAttributesByParameterListEntry(this, PARAMETER_CHANGE_ATTRIBUTES, 0), new String[0]));
    }

    @Override
    protected MetaData modifyMetaData(ExampleSetMetaData metaData) {
        try {
            String targetRole = null;
            if (this.isParameterSet(PARAMETER_TARGET_ROLE)) {
                targetRole = this.getParameterAsString(PARAMETER_TARGET_ROLE);
            }
            if (this.isParameterSet(PARAMETER_NAME)) {
                String name = this.getParameter(PARAMETER_NAME);
                this.setRoleMetaData(metaData, name, targetRole);
            }
            if (this.isParameterSet(PARAMETER_CHANGE_ATTRIBUTES)) {
                List<String[]> list = this.getParameterList(PARAMETER_CHANGE_ATTRIBUTES);
                for (String[] pairs : list) {
                    this.setRoleMetaData(metaData, pairs[0], pairs[1]);
                }
            }
        }
        catch (UndefinedParameterError undefinedParameterError) {
            // empty catch block
        }
        return metaData;
    }

    private void setRoleMetaData(ExampleSetMetaData metaData, String name, String targetRole) {
        AttributeMetaData amd = metaData.getAttributeByName(name);
        if (amd != null && targetRole != null) {
            if (REGULAR_NAME.equals(targetRole)) {
                amd.setRegular();
            } else {
                AttributeMetaData oldRole = metaData.getAttributeByRole(targetRole);
                if (oldRole != null && oldRole != amd) {
                    this.getInputPort().addError(new SimpleMetaDataError(ProcessSetupError.Severity.WARNING, (Port)this.getInputPort(), "already_contains_role", targetRole));
                    metaData.removeAttribute(oldRole);
                }
                amd.setRole(targetRole);
            }
        }
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        String name = this.getParameterAsString(PARAMETER_NAME);
        String newRole = this.getParameterAsString(PARAMETER_TARGET_ROLE);
        this.setRole(exampleSet, name, newRole);
        if (this.isParameterSet(PARAMETER_CHANGE_ATTRIBUTES)) {
            List<String[]> list = this.getParameterList(PARAMETER_CHANGE_ATTRIBUTES);
            for (String[] pairs : list) {
                this.setRole(exampleSet, pairs[0], pairs[1]);
            }
        }
        return exampleSet;
    }

    private void setRole(ExampleSet exampleSet, String name, String newRole) throws UserError {
        Attribute attribute = exampleSet.getAttributes().get(name);
        if (attribute == null) {
            throw new UserError((Operator)this, 111, name);
        }
        exampleSet.getAttributes().remove(attribute);
        if (newRole == null || newRole.trim().length() == 0) {
            throw new UserError((Operator)this, 205, PARAMETER_TARGET_ROLE);
        }
        if (newRole.equals(REGULAR_NAME)) {
            exampleSet.getAttributes().addRegular(attribute);
        } else {
            exampleSet.getAttributes().setSpecialAttribute(attribute, newRole);
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeAttribute(PARAMETER_NAME, "The name of the attribute whose role should be changed.", this.getExampleSetInputPort(), false, false));
        ParameterTypeStringCategory type = new ParameterTypeStringCategory(PARAMETER_TARGET_ROLE, "The target role of the attribute (only changed if parameter change_attribute_type is true).", TARGET_ROLES, TARGET_ROLES[0]);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeList(PARAMETER_CHANGE_ATTRIBUTES, "This parameter defines additional attribute role combinations.", (ParameterType)new ParameterTypeAttribute(PARAMETER_NAME, "The name of the attribute whose role should be changed.", this.getExampleSetInputPort(), false, false), (ParameterType)new ParameterTypeStringCategory(PARAMETER_TARGET_ROLE, "The target role of the attribute (only changed if parameter change_attribute_type is true).", TARGET_ROLES, TARGET_ROLES[0]), false));
        return types;
    }

    @Override
    public boolean writesIntoExistingData() {
        return false;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), ChangeAttributeRole.class, null);
    }
}

